/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.model.app.dataentity.IPSAppDEUIActionGroup;
import net.ibizsys.model.app.dataentity.IPSAppDataEntity;
import net.ibizsys.model.dataentity.uiaction.IPSDEUIActionGroup;
import net.ibizsys.psmodel.core.domain.PSDEUAGroup;
import net.ibizsys.psmodel.core.domain.PSDataEntity;
import net.ibizsys.psmodel.core.filter.PSDEUAGroupFilter;
import net.ibizsys.psmodel.core.service.IPSDEUAGroupService;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSDEUAGroupRTService
extends PSModelRTServiceBase<PSDEUAGroup, PSDEUAGroupFilter>
implements IPSDEUAGroupService {
    private static final Log log = LogFactory.getLog(PSDEUAGroupRTService.class);

    public PSDEUAGroup createDomain() {
        return new PSDEUAGroup();
    }

    public PSDEUAGroupFilter createFilter() {
        return new PSDEUAGroupFilter();
    }

    public PSDEUAGroup getDomain(Object params) {
        if (params instanceof PSDEUAGroup) {
            return (PSDEUAGroup)params;
        }
        return (PSDEUAGroup)PSDEUAGroupRTService.getMapper().convertValue(params, PSDEUAGroup.class);
    }

    public PSDEUAGroupFilter getFilter(Object params) {
        if (params instanceof PSDEUAGroupFilter) {
            return (PSDEUAGroupFilter)params;
        }
        return (PSDEUAGroupFilter)PSDEUAGroupRTService.getMapper().convertValue(params, PSDEUAGroupFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDEUAGROUP";
        }
        return "PSDEUAGROUPS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSDEUIActionGroup.class;
    }

    @Override
    protected List<IPSDEUIActionGroup> getPSModelObjectList(PSDEUAGroupFilter f) throws Exception {
        Object objPSDEId = f.getFieldCond("psdeid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            objPSDEId = PSDEUAGroupRTService.getParentId((IPSModelFilter)f, "PSDATAENTITY");
        }
        String strPSDEId = null;
        if (objPSDEId != null) {
            strPSDEId = (String)objPSDEId;
        }
        HashMap<String, IPSAppDEUIActionGroup> psDEUIActionGroupMap = new HashMap<String, IPSAppDEUIActionGroup>();
        ArrayList<IPSDEUIActionGroup> psAppDEUIActionGroupList = new ArrayList<IPSDEUIActionGroup>();
        if (!ObjectUtils.isEmpty((Object)this.getPSSystemService().getPSSystem().getAllPSApps())) {
            for (IPSApplication iPSApplication : this.getPSSystemService().getPSSystem().getAllPSApps()) {
                if (ObjectUtils.isEmpty((Object)iPSApplication.getAllPSAppDataEntities())) continue;
                for (IPSAppDataEntity iPSAppDataEntity : iPSApplication.getAllPSAppDataEntities()) {
                    if (iPSAppDataEntity.getPSDataEntity() == null || ObjectUtils.isEmpty((Object)iPSAppDataEntity.getAllPSAppDEUIActionGroups())) continue;
                    for (IPSAppDEUIActionGroup iPSAppDEUIActionGroup : iPSAppDataEntity.getAllPSAppDEUIActionGroups()) {
                        String strId = this.getPSModelRTServiceSession().getPSModelUniqueTag((IPSModelObject)iPSAppDataEntity.getPSDataEntity());
                        if (strPSDEId != null && !strPSDEId.equals(strId)) continue;
                        psDEUIActionGroupMap.put(this.getPSModelRTServiceSession().getPSModelUniqueTag((IPSModelObject)iPSAppDEUIActionGroup), iPSAppDEUIActionGroup);
                    }
                }
            }
        }
        psAppDEUIActionGroupList.clear();
        psAppDEUIActionGroupList.addAll(psDEUIActionGroupMap.values());
        return psAppDEUIActionGroupList;
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSDEUIActionGroup.class, this.getPSModelObjectList(new PSDEUAGroupFilter()), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDEUAGroup domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        PSDataEntity parentPSModel = (PSDataEntity)this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", PSDEUAGroupRTService.getParentId(domain.getId()));
        domain.setPSDEId(parentPSModel.getId());
        domain.setPSDEName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

