/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.service.IPSDEServiceAPI;
import net.ibizsys.model.service.IPSSysServiceAPI;
import net.ibizsys.psmodel.core.domain.PSDEServiceAPI;
import net.ibizsys.psmodel.core.filter.PSDEServiceAPIFilter;
import net.ibizsys.psmodel.core.service.IPSDEServiceAPIService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSDEServiceAPIRTService
extends PSModelRTServiceBase<PSDEServiceAPI, PSDEServiceAPIFilter>
implements IPSDEServiceAPIService {
    private static final Log log = LogFactory.getLog(PSDEServiceAPIRTService.class);

    public PSDEServiceAPI createDomain() {
        return new PSDEServiceAPI();
    }

    public PSDEServiceAPIFilter createFilter() {
        return new PSDEServiceAPIFilter();
    }

    public PSDEServiceAPI getDomain(Object params) {
        if (params instanceof PSDEServiceAPI) {
            return (PSDEServiceAPI)params;
        }
        return (PSDEServiceAPI)PSDEServiceAPIRTService.getMapper().convertValue(params, PSDEServiceAPI.class);
    }

    public PSDEServiceAPIFilter getFilter(Object params) {
        if (params instanceof PSDEServiceAPIFilter) {
            return (PSDEServiceAPIFilter)params;
        }
        return (PSDEServiceAPIFilter)PSDEServiceAPIRTService.getMapper().convertValue(params, PSDEServiceAPIFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDESERVICEAPI";
        }
        return "PSDESERVICEAPIS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSDEServiceAPI.class;
    }

    @Override
    protected List<? extends IPSDEServiceAPI> getPSModelObjectList(PSDEServiceAPIFilter f) throws Exception {
        Object objPSSysServiceAPIId = f.getFieldCond("pssysserviceapiid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSSysServiceAPIId)) {
            objPSSysServiceAPIId = PSDEServiceAPIRTService.getParentId((IPSModelFilter)f, "PSSYSSERVICEAPI");
        }
        if (ObjectUtils.isEmpty((Object)objPSSysServiceAPIId)) {
            List psSysServiceAPIList = this.getPSSystemService().getPSSystem().getAllPSSysServiceAPIs();
            if (ObjectUtils.isEmpty((Object)psSysServiceAPIList)) {
                return null;
            }
            ArrayList psDEServiceAPIList = new ArrayList();
            for (IPSSysServiceAPI iPSSysServiceAPI : psSysServiceAPIList) {
                if (ObjectUtils.isEmpty((Object)iPSSysServiceAPI.getPSDEServiceAPIs())) continue;
                psDEServiceAPIList.addAll(iPSSysServiceAPI.getPSDEServiceAPIs());
            }
            return psDEServiceAPIList;
        }
        return this.getPSModelObject(IPSSysServiceAPI.class, this.getPSSystemService().getPSSystem().getAllPSSysServiceAPIs(), (String)objPSSysServiceAPIId, false).getPSDEServiceAPIs();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSDEServiceAPI.class, this.getPSModelObject(IPSSysServiceAPI.class, this.getPSSystemService().getPSSystem().getAllPSSysServiceAPIs(), PSDEServiceAPIRTService.getParentId(key), false).getPSDEServiceAPIs(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDEServiceAPI domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSSYSSERVICEAPI", PSDEServiceAPIRTService.getParentId(domain.getId()));
        domain.setPSSysServiceAPIId(parentPSModel.getId());
        domain.setPSSysServiceAPIName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

