/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.service.IPSDEServiceAPIRS;
import net.ibizsys.model.service.IPSSysServiceAPI;
import net.ibizsys.psmodel.core.domain.PSDESARS;
import net.ibizsys.psmodel.core.filter.PSDESARSFilter;
import net.ibizsys.psmodel.core.service.IPSDESARSService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSDESARSRTService
extends PSModelRTServiceBase<PSDESARS, PSDESARSFilter>
implements IPSDESARSService {
    private static final Log log = LogFactory.getLog(PSDESARSRTService.class);

    public PSDESARS createDomain() {
        return new PSDESARS();
    }

    public PSDESARSFilter createFilter() {
        return new PSDESARSFilter();
    }

    public PSDESARS getDomain(Object params) {
        if (params instanceof PSDESARS) {
            return (PSDESARS)params;
        }
        return (PSDESARS)PSDESARSRTService.getMapper().convertValue(params, PSDESARS.class);
    }

    public PSDESARSFilter getFilter(Object params) {
        if (params instanceof PSDESARSFilter) {
            return (PSDESARSFilter)params;
        }
        return (PSDESARSFilter)PSDESARSRTService.getMapper().convertValue(params, PSDESARSFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDESARS";
        }
        return "PSDESARS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSDEServiceAPIRS.class;
    }

    @Override
    protected List<? extends IPSDEServiceAPIRS> getPSModelObjectList(PSDESARSFilter f) throws Exception {
        Object objPSSysServiceAPIId = f.getFieldCond("pssysserviceapiid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSSysServiceAPIId)) {
            objPSSysServiceAPIId = PSDESARSRTService.getParentId((IPSModelFilter)f, "PSSYSSERVICEAPI");
        }
        if (ObjectUtils.isEmpty((Object)objPSSysServiceAPIId)) {
            List psSysServiceAPIList = this.getPSSystemService().getPSSystem().getAllPSSysServiceAPIs();
            if (ObjectUtils.isEmpty((Object)psSysServiceAPIList)) {
                return null;
            }
            ArrayList psDEServiceAPIList = new ArrayList();
            for (IPSSysServiceAPI iPSSysServiceAPI : psSysServiceAPIList) {
                if (ObjectUtils.isEmpty((Object)iPSSysServiceAPI.getPSDEServiceAPIRSs())) continue;
                psDEServiceAPIList.addAll(iPSSysServiceAPI.getPSDEServiceAPIRSs());
            }
            return psDEServiceAPIList;
        }
        return this.getPSModelObject(IPSSysServiceAPI.class, this.getPSSystemService().getPSSystem().getAllPSSysServiceAPIs(), (String)objPSSysServiceAPIId, false).getPSDEServiceAPIRSs();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSDEServiceAPIRS.class, this.getPSModelObject(IPSSysServiceAPI.class, this.getPSSystemService().getPSSystem().getAllPSSysServiceAPIs(), PSDESARSRTService.getParentId(key), false).getPSDEServiceAPIRSs(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDESARS domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSSYSSERVICEAPI", PSDESARSRTService.getParentId(domain.getId()));
        domain.setPSSysServiceAPIId(parentPSModel.getId());
        domain.setPSSysServiceAPIName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

