/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.der.IPSDERBase;
import net.ibizsys.psmodel.core.domain.PSDER;
import net.ibizsys.psmodel.core.filter.PSDERFilter;
import net.ibizsys.psmodel.core.service.IPSDERService;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSDERRTService
extends PSModelRTServiceBase<PSDER, PSDERFilter>
implements IPSDERService {
    private static final Log log = LogFactory.getLog(PSDERRTService.class);

    public PSDER createDomain() {
        return new PSDER();
    }

    public PSDERFilter createFilter() {
        return new PSDERFilter();
    }

    public PSDER getDomain(Object params) {
        if (params instanceof PSDER) {
            return (PSDER)params;
        }
        return (PSDER)PSDERRTService.getMapper().convertValue(params, PSDER.class);
    }

    public PSDERFilter getFilter(Object params) {
        if (params instanceof PSDERFilter) {
            return (PSDERFilter)params;
        }
        return (PSDERFilter)PSDERRTService.getMapper().convertValue(params, PSDERFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDER";
        }
        return "PSDERS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSDERBase.class;
    }

    @Override
    protected List<? extends IPSDERBase> getPSModelObjectList(PSDERFilter f) throws Exception {
        Object objPSDEId = f.getFieldCond("minorpsdeid", "EQ");
        if (!ObjectUtils.isEmpty((Object)objPSDEId)) {
            return this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), (String)objPSDEId, false).getMinorPSDERs();
        }
        if (this.getPSSystemService().getPSSystem().getAllPSDataEntities() == null) {
            return null;
        }
        ArrayList allPSDERList = new ArrayList();
        for (IPSDataEntity iPSDataEntity : this.getPSSystemService().getPSSystem().getAllPSDataEntities()) {
            if (iPSDataEntity.getMinorPSDERs() == null) continue;
            allPSDERList.addAll(iPSDataEntity.getMinorPSDERs());
        }
        return allPSDERList;
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSDERBase.class, this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), PSDERRTService.getParentId(key), false).getMinorPSDERs(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDER domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

