/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.logic.IPSDEMSLogic;
import net.ibizsys.psmodel.core.domain.PSDELogic;
import net.ibizsys.psmodel.core.filter.PSDELogicFilter;
import net.ibizsys.psmodel.core.service.IPSDELogicService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.core.util.PSModelEnums;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSDEMSLogicRTService
extends PSModelRTServiceBase<PSDELogic, PSDELogicFilter>
implements IPSDELogicService {
    private static final Log log = LogFactory.getLog(PSDEMSLogicRTService.class);

    public PSDELogic createDomain() {
        return new PSDELogic();
    }

    public PSDELogicFilter createFilter() {
        return new PSDELogicFilter();
    }

    public PSDELogic getDomain(Object params) {
        if (params instanceof PSDELogic) {
            return (PSDELogic)params;
        }
        return (PSDELogic)PSDEMSLogicRTService.getMapper().convertValue(params, PSDELogic.class);
    }

    public PSDELogicFilter getFilter(Object params) {
        if (params instanceof PSDELogicFilter) {
            return (PSDELogicFilter)params;
        }
        return (PSDELogicFilter)PSDEMSLogicRTService.getMapper().convertValue(params, PSDELogicFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDEMSLOGIC";
        }
        return "PSDEMSLOGICS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSDEMSLogic.class;
    }

    @Override
    protected List<? extends IPSDEMSLogic> getPSModelObjectList(PSDELogicFilter f) throws Exception {
        Object objPSDEId = f.getFieldCond("psdeid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            objPSDEId = PSDEMSLogicRTService.getParentId((IPSModelFilter)f, "PSDATAENTITY");
        }
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            if (this.getPSSystemService().getPSSystem().getAllPSDataEntities() == null) {
                return null;
            }
            ArrayList allPSDEMSLogicList = new ArrayList();
            for (IPSDataEntity iPSDataEntity : this.getPSSystemService().getPSSystem().getAllPSDataEntities()) {
                if (iPSDataEntity.getAllPSDEMSLogics() == null) continue;
                allPSDEMSLogicList.addAll(iPSDataEntity.getAllPSDEMSLogics());
            }
            return allPSDEMSLogicList;
        }
        return this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), (String)objPSDEId, false).getAllPSDEMSLogics();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSDEMSLogic.class, this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), PSDEMSLogicRTService.getParentId(key), false).getAllPSDEMSLogics(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDELogic domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", PSDEMSLogicRTService.getParentId(domain.getId()));
        domain.setPSDEId(parentPSModel.getId());
        domain.setPSDEName(parentPSModel.getName());
        domain.logictype(PSModelEnums.LogicType.DATAFLOWLOGIC);
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

