/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.logic.IPSDELogic;
import net.ibizsys.psmodel.core.domain.PSDELogic;
import net.ibizsys.psmodel.core.domain.PSDataEntity;
import net.ibizsys.psmodel.core.filter.PSDELogicFilter;
import net.ibizsys.psmodel.core.service.IPSDELogicService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.core.util.PSModelEnums;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class PSDELogicRTService
extends PSModelRTServiceBase<PSDELogic, PSDELogicFilter>
implements IPSDELogicService {
    private static final Log log = LogFactory.getLog(PSDELogicRTService.class);

    public PSDELogic createDomain() {
        return new PSDELogic();
    }

    public PSDELogicFilter createFilter() {
        return new PSDELogicFilter();
    }

    public PSDELogic getDomain(Object params) {
        if (params instanceof PSDELogic) {
            return (PSDELogic)params;
        }
        return (PSDELogic)PSDELogicRTService.getMapper().convertValue(params, PSDELogic.class);
    }

    public PSDELogicFilter getFilter(Object params) {
        if (params instanceof PSDELogicFilter) {
            return (PSDELogicFilter)params;
        }
        return (PSDELogicFilter)PSDELogicRTService.getMapper().convertValue(params, PSDELogicFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDELOGIC";
        }
        return "PSDELOGICS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSDELogic.class;
    }

    @Override
    protected List<? extends IPSDELogic> getPSModelObjectList(PSDELogicFilter f) throws Exception {
        Object objPSDEId = f.getFieldCond("psdeid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            objPSDEId = PSDELogicRTService.getParentId((IPSModelFilter)f, "PSDATAENTITY");
        }
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            if (this.getPSSystemService().getPSSystem().getAllPSDataEntities() == null) {
                return null;
            }
            ArrayList allPSDELogicList = new ArrayList();
            for (IPSDataEntity iPSDataEntity : this.getPSSystemService().getPSSystem().getAllPSDataEntities()) {
                if (iPSDataEntity.getAllPSDELogics() == null) continue;
                allPSDELogicList.addAll(iPSDataEntity.getAllPSDELogics());
            }
            return allPSDELogicList;
        }
        return this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), (String)objPSDEId, false).getAllPSDELogics();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSDELogic.class, this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), PSDELogicRTService.getParentId(key), false).getAllPSDELogics(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDELogic domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", PSDELogicRTService.getParentId(domain.getId()));
        domain.setPSDEId(parentPSModel.getId());
        domain.setPSDEName(parentPSModel.getName());
        domain.logictype(PSModelEnums.LogicType.DELOGIC);
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }

    protected void onBeforeCreate(PSDELogic m) throws Exception {
        if (!StringUtils.hasLength((String)m.getPSDEId())) {
            throw new Exception("\u672a\u4f20\u5165\u5b9e\u4f53\u6807\u8bc6");
        }
        PSDataEntity psDataEntity = (PSDataEntity)this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", m.getPSDEId());
        String strLogicSubType = m.getLogicSubType();
        if (StringUtils.hasLength((String)strLogicSubType) && !PSModelEnums.LogicSubType.NONE.value.equals(strLogicSubType) && !PSModelEnums.LogicSubType.DEFIELD.value.equals(strLogicSubType)) {
            m.resetCodeName();
            m.setCodeName(String.format("ux%1$s%2$s", strLogicSubType.toLowerCase(), this.getRandom().nextInt(9999999)));
        }
        if (!StringUtils.hasLength((String)m.getCodeName())) {
            m.setCodeName(String.format("uxlogic%1$s", this.getRandom().nextInt(9999999)));
        }
        String strPSDELogicId = String.format("%1$s.%2$s", m.getPSDEId(), m.getCodeName().toLowerCase());
        m.setPSDELogicId(strPSDELogicId);
        m.setPSDEName(psDataEntity.getPSDataEntityName());
        super.onBeforeCreate((IPSModel)m);
    }
}

