/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.control.IPSControl;
import net.ibizsys.model.control.list.IPSDEList;
import net.ibizsys.psmodel.core.domain.PSDEList;
import net.ibizsys.psmodel.core.domain.PSDataEntity;
import net.ibizsys.psmodel.core.filter.PSDEListFilter;
import net.ibizsys.psmodel.core.service.IPSDEListService;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class PSDEListRTService
extends PSModelRTServiceBase<PSDEList, PSDEListFilter>
implements IPSDEListService {
    private static final Log log = LogFactory.getLog(PSDEListRTService.class);

    public PSDEList createDomain() {
        return new PSDEList();
    }

    public PSDEListFilter createFilter() {
        return new PSDEListFilter();
    }

    public PSDEList getDomain(Object params) {
        if (params instanceof PSDEList) {
            return (PSDEList)params;
        }
        return (PSDEList)PSDEListRTService.getMapper().convertValue(params, PSDEList.class);
    }

    public PSDEListFilter getFilter(Object params) {
        if (params instanceof PSDEListFilter) {
            return (PSDEListFilter)params;
        }
        return (PSDEListFilter)PSDEListRTService.getMapper().convertValue(params, PSDEListFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDELIST";
        }
        return "PSDELISTS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSControl.class;
    }

    @Override
    protected List<IPSDEList> getPSModelObjectList(PSDEListFilter f) throws Exception {
        Object objPSDEId = f.getFieldCond("psdeid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            objPSDEId = PSDEListRTService.getParentId((IPSModelFilter)f, "PSDATAENTITY");
        }
        String strPSDEId = null;
        if (objPSDEId != null) {
            strPSDEId = (String)objPSDEId;
        }
        ArrayList<IPSDEList> psDEListList = new ArrayList<IPSDEList>();
        this.fillPSControlList(IPSDEList.class, psDEListList);
        HashMap<String, IPSDEList> psDEListMap = new HashMap<String, IPSDEList>();
        for (IPSDEList iPSDEList : psDEListList) {
            String strId;
            if (StringUtils.hasLength((String)strPSDEId) && (iPSDEList.getPSAppDataEntity() == null || iPSDEList.getPSAppDataEntity().getPSDataEntity() == null || !strPSDEId.equals(strId = this.getPSModelRTServiceSession().getPSModelUniqueTag((IPSModelObject)iPSDEList.getPSAppDataEntity().getPSDataEntity())))) continue;
            psDEListMap.put(this.getPSModelRTServiceSession().getPSModelUniqueTag((IPSModelObject)iPSDEList), iPSDEList);
        }
        psDEListList.clear();
        psDEListList.addAll(psDEListMap.values());
        return psDEListList;
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSDEList.class, this.getPSModelObjectList(new PSDEListFilter()), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDEList domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        PSDataEntity parentPSModel = (PSDataEntity)this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", PSDEListRTService.getParentId(domain.getId()));
        domain.setPSDEId(parentPSModel.getId());
        domain.setPSDEName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

