/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.control.IPSControl;
import net.ibizsys.model.control.form.IPSDEForm;
import net.ibizsys.psmodel.core.domain.PSDEForm;
import net.ibizsys.psmodel.core.domain.PSDataEntity;
import net.ibizsys.psmodel.core.filter.PSDEFormFilter;
import net.ibizsys.psmodel.core.service.IPSDEFormService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.core.util.PSModelEnums;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class PSDEFormRTService
extends PSModelRTServiceBase<PSDEForm, PSDEFormFilter>
implements IPSDEFormService {
    private static final Log log = LogFactory.getLog(PSDEFormRTService.class);

    public PSDEForm createDomain() {
        return new PSDEForm();
    }

    public PSDEFormFilter createFilter() {
        return new PSDEFormFilter();
    }

    public PSDEForm getDomain(Object params) {
        if (params instanceof PSDEForm) {
            return (PSDEForm)params;
        }
        return (PSDEForm)PSDEFormRTService.getMapper().convertValue(params, PSDEForm.class);
    }

    public PSDEFormFilter getFilter(Object params) {
        if (params instanceof PSDEFormFilter) {
            return (PSDEFormFilter)params;
        }
        return (PSDEFormFilter)PSDEFormRTService.getMapper().convertValue(params, PSDEFormFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDEFORM";
        }
        return "PSDEFORMS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSControl.class;
    }

    @Override
    protected List<IPSDEForm> getPSModelObjectList(PSDEFormFilter f) throws Exception {
        Object objPSDEId = f.getFieldCond("psdeid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            objPSDEId = PSDEFormRTService.getParentId((IPSModelFilter)f, "PSDATAENTITY");
        }
        String strPSDEId = null;
        if (objPSDEId != null) {
            strPSDEId = (String)objPSDEId;
        }
        ArrayList<IPSDEForm> psDEFormList = new ArrayList<IPSDEForm>();
        this.fillPSControlList(IPSDEForm.class, psDEFormList);
        HashMap<String, IPSDEForm> psDEFormMap = new HashMap<String, IPSDEForm>();
        for (IPSDEForm iPSDEForm : psDEFormList) {
            String strId;
            if (StringUtils.hasLength((String)strPSDEId) && (iPSDEForm.getPSAppDataEntity() == null || iPSDEForm.getPSAppDataEntity().getPSDataEntity() == null || !strPSDEId.equals(strId = this.getPSModelRTServiceSession().getPSModelUniqueTag((IPSModelObject)iPSDEForm.getPSAppDataEntity().getPSDataEntity())))) continue;
            psDEFormMap.put(this.getPSModelRTServiceSession().getPSModelUniqueTag((IPSModelObject)iPSDEForm), iPSDEForm);
        }
        psDEFormList.clear();
        psDEFormList.addAll(psDEFormMap.values());
        return psDEFormList;
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSDEForm.class, this.getPSModelObjectList(new PSDEFormFilter()), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDEForm domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        PSDataEntity parentPSModel = (PSDataEntity)this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", PSDEFormRTService.getParentId(domain.getId()));
        domain.setPSDEId(parentPSModel.getId());
        domain.setPSDEName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }

    @Override
    protected Map<String, Object> getDataSetConds(String strDataSetName, PSDEFormFilter f) {
        if ("CurDEEditMode".equalsIgnoreCase(strDataSetName)) {
            return new HashMap<String, Object>(){
                {
                    this.put("n_formtype_eq", "EDITFORM");
                }
            };
        }
        if ("CurDESearchMode".equalsIgnoreCase(strDataSetName)) {
            return new HashMap<String, Object>(){
                {
                    this.put("n_formtype_eq", "SEARCHFORM");
                }
            };
        }
        if ("CurDEWizardMode".equalsIgnoreCase(strDataSetName)) {
            return new HashMap<String, Object>(){
                {
                    this.put("n_formtype_eq", "EDITFORM");
                    this.put("n_funcmode_eq", "WIZARDFORM");
                }
            };
        }
        return super.getDataSetConds(strDataSetName, f);
    }

    protected void onBeforeCreate(PSDEForm m) throws Exception {
        if (!StringUtils.hasLength((String)m.getPSDEId())) {
            throw new Exception("\u672a\u4f20\u5165\u5b9e\u4f53\u6807\u8bc6");
        }
        PSDataEntity psDataEntity = (PSDataEntity)this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", m.getPSDEId());
        String strFormType = m.getFormType();
        if (!StringUtils.hasLength((String)strFormType)) {
            strFormType = PSModelEnums.FormType.EDITFORM.value;
            m.setFormType(strFormType);
        }
        if (!StringUtils.hasLength((String)m.getCodeName())) {
            m.setCodeName(String.format("ux%1$s%2$s", m.getFormType().toLowerCase(), this.getRandom().nextInt(9999999)));
        }
        String strPSDFormId = String.format("%1$s.%2$s", m.getPSDEId(), m.getCodeName().toLowerCase());
        m.setPSDEFormId(strPSDFormId);
        m.setPSDEName(psDataEntity.getPSDataEntityName());
        super.onBeforeCreate((IPSModel)m);
    }
}

