/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.psmodel.core.domain.PSDEField;
import net.ibizsys.psmodel.core.domain.PSDataEntity;
import net.ibizsys.psmodel.core.filter.PSDEFieldFilter;
import net.ibizsys.psmodel.core.service.IPSDEFieldService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class PSDEFieldRTService
extends PSModelRTServiceBase<PSDEField, PSDEFieldFilter>
implements IPSDEFieldService {
    private static final Log log = LogFactory.getLog(PSDEFieldRTService.class);

    public PSDEField createDomain() {
        return new PSDEField();
    }

    public PSDEFieldFilter createFilter() {
        return new PSDEFieldFilter();
    }

    public PSDEField getDomain(Object params) {
        if (params instanceof PSDEField) {
            return (PSDEField)params;
        }
        return (PSDEField)PSDEFieldRTService.getMapper().convertValue(params, PSDEField.class);
    }

    public PSDEFieldFilter getFilter(Object params) {
        if (params instanceof PSDEFieldFilter) {
            return (PSDEFieldFilter)params;
        }
        return (PSDEFieldFilter)PSDEFieldRTService.getMapper().convertValue(params, PSDEFieldFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDEFIELD";
        }
        return "PSDEFIELDS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSDEField.class;
    }

    @Override
    protected List<? extends IPSDEField> getPSModelObjectList(PSDEFieldFilter f) throws Exception {
        Object objPSDEId = f.getFieldCond("psdeid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEId) && ObjectUtils.isEmpty((Object)(objPSDEId = PSDEFieldRTService.getParentId((IPSModelFilter)f, "PSDATAENTITY")))) {
            throw new Exception("\u672a\u6307\u5b9a\u5b9e\u4f53\u6807\u8bc6");
        }
        return this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), (String)objPSDEId, false).getAllPSDEFields();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSDEField.class, this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), PSDEFieldRTService.getParentId(key), false).getAllPSDEFields(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDEField domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", PSDEFieldRTService.getParentId(domain.getId()));
        domain.setPSDEId(parentPSModel.getId());
        domain.setPSDEName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }

    protected void onBeforeCreate(PSDEField m) throws Exception {
        if (!StringUtils.hasLength((String)m.getPSDEId())) {
            throw new Exception("\u672a\u4f20\u5165\u5b9e\u4f53\u6807\u8bc6");
        }
        PSDataEntity psDataEntity = (PSDataEntity)this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", m.getPSDEId());
        String strPSDEFieldName = m.getPSDEFieldName();
        if (!StringUtils.hasLength((String)strPSDEFieldName)) {
            strPSDEFieldName = String.format("uxfield%1$s", this.getRandom().nextInt(99999));
        } else if (strPSDEFieldName.indexOf("ux") == -1) {
            strPSDEFieldName = String.format("ux%1$s", strPSDEFieldName);
        }
        String strFieldId = String.format("%1$s.%2$s", m.getPSDEId(), strPSDEFieldName.toLowerCase());
        m.setPSDEFieldId(strFieldId);
        m.setPSDEFieldName(strPSDEFieldName.toUpperCase());
        m.setCodeName(strPSDEFieldName.toLowerCase());
        m.setPSDEName(psDataEntity.getPSDataEntityName());
        if (!StringUtils.hasLength((String)m.getPSDataTypeId())) {
            m.setPSDataTypeId(PSModelEnums.DEFDataType.TEXT.value);
            m.setPSDataTypeName(PSModelEnums.DEFDataType.TEXT.text);
        }
        super.onBeforeCreate((IPSModel)m);
    }

    protected void onBeforeUpdate(PSDEField m) throws Exception {
        super.onBeforeUpdate((IPSModel)m);
    }
}

