/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.defield.IPSDEFSearchMode;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.psmodel.core.domain.PSDEFSFItem;
import net.ibizsys.psmodel.core.domain.PSDEField;
import net.ibizsys.psmodel.core.filter.PSDEFSFItemFilter;
import net.ibizsys.psmodel.core.service.IPSDEFSFItemService;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSDEFSFItemRTService
extends PSModelRTServiceBase<PSDEFSFItem, PSDEFSFItemFilter>
implements IPSDEFSFItemService {
    private static final Log log = LogFactory.getLog(PSDEFSFItemRTService.class);

    public PSDEFSFItem createDomain() {
        return new PSDEFSFItem();
    }

    public PSDEFSFItemFilter createFilter() {
        return new PSDEFSFItemFilter();
    }

    public PSDEFSFItem getDomain(Object params) {
        if (params instanceof PSDEFSFItem) {
            return (PSDEFSFItem)params;
        }
        return (PSDEFSFItem)PSDEFSFItemRTService.getMapper().convertValue(params, PSDEFSFItem.class);
    }

    public PSDEFSFItemFilter getFilter(Object params) {
        if (params instanceof PSDEFSFItemFilter) {
            return (PSDEFSFItemFilter)params;
        }
        return (PSDEFSFItemFilter)PSDEFSFItemRTService.getMapper().convertValue(params, PSDEFSFItemFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDEFSFITEM";
        }
        return "PSDEFSFITEMS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSDEFSearchMode.class;
    }

    @Override
    protected List<? extends IPSDEFSearchMode> getPSModelObjectList(PSDEFSFItemFilter f) throws Exception {
        Object objPSDEFieldId = f.getFieldCond("psdefid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEFieldId)) {
            objPSDEFieldId = PSDEFSFItemRTService.getParentId((IPSModelFilter)f, "PSDEFIELD");
        }
        if (ObjectUtils.isEmpty((Object)objPSDEFieldId)) {
            if (this.getPSSystemService().getPSSystem().getAllPSDataEntities() == null) {
                return null;
            }
            ArrayList allPSDEFSearchModeList = new ArrayList();
            for (IPSDataEntity iPSDataEntity : this.getPSSystemService().getPSSystem().getAllPSDataEntities()) {
                if (iPSDataEntity.getAllPSDEFields() == null) continue;
                for (IPSDEField iPSDEField : iPSDataEntity.getAllPSDEFields()) {
                    if (ObjectUtils.isEmpty((Object)iPSDEField.getAllPSDEFSearchModes())) continue;
                    allPSDEFSearchModeList.addAll(iPSDEField.getAllPSDEFSearchModes());
                }
            }
            return allPSDEFSearchModeList;
        }
        String strPSDEId = PSDEFSFItemRTService.getParentId((String)objPSDEFieldId);
        IPSDEField iPSDEField = this.getPSModelObject(IPSDEField.class, this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), strPSDEId, false).getAllPSDEFields(), (String)objPSDEFieldId, false);
        return iPSDEField.getAllPSDEFSearchModes();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        String strPSDEFieldId = PSDEFSFItemRTService.getParentId(key);
        String strPSDEId = PSDEFSFItemRTService.getParentId(strPSDEFieldId);
        IPSDEField iPSDEField = this.getPSModelObject(IPSDEField.class, this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), strPSDEId, false).getAllPSDEFields(), strPSDEFieldId, false);
        return this.getPSModelObject(IPSDEFSearchMode.class, iPSDEField.getAllPSDEFSearchModes(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDEFSFItem domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        PSDEField parentPSModel = (PSDEField)this.getPSModelRTServiceSession().getCachePSModel("PSDEFIELD", PSDEFSFItemRTService.getParentId(domain.getId()));
        domain.setPSDEFId(parentPSModel.getId());
        domain.setPSDEFName(parentPSModel.getName());
        domain.setPSDEId(parentPSModel.getPSDEId());
        domain.setPSDEName(parentPSModel.getPSDEName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

