/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.control.IPSControl;
import net.ibizsys.model.control.dataview.IPSDEDataView;
import net.ibizsys.psmodel.core.domain.PSDEDataView;
import net.ibizsys.psmodel.core.domain.PSDataEntity;
import net.ibizsys.psmodel.core.filter.PSDEDataViewFilter;
import net.ibizsys.psmodel.core.service.IPSDEDataViewService;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class PSDEDataViewRTService
extends PSModelRTServiceBase<PSDEDataView, PSDEDataViewFilter>
implements IPSDEDataViewService {
    private static final Log log = LogFactory.getLog(PSDEDataViewRTService.class);

    public PSDEDataView createDomain() {
        return new PSDEDataView();
    }

    public PSDEDataViewFilter createFilter() {
        return new PSDEDataViewFilter();
    }

    public PSDEDataView getDomain(Object params) {
        if (params instanceof PSDEDataView) {
            return (PSDEDataView)params;
        }
        return (PSDEDataView)PSDEDataViewRTService.getMapper().convertValue(params, PSDEDataView.class);
    }

    public PSDEDataViewFilter getFilter(Object params) {
        if (params instanceof PSDEDataViewFilter) {
            return (PSDEDataViewFilter)params;
        }
        return (PSDEDataViewFilter)PSDEDataViewRTService.getMapper().convertValue(params, PSDEDataViewFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDEDATAVIEW";
        }
        return "PSDEDATAVIEWS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSControl.class;
    }

    @Override
    protected List<IPSDEDataView> getPSModelObjectList(PSDEDataViewFilter f) throws Exception {
        Object objPSDEId = f.getFieldCond("psdeid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            objPSDEId = PSDEDataViewRTService.getParentId((IPSModelFilter)f, "PSDATAENTITY");
        }
        String strPSDEId = null;
        if (objPSDEId != null) {
            strPSDEId = (String)objPSDEId;
        }
        ArrayList<IPSDEDataView> psDEDataViewList = new ArrayList<IPSDEDataView>();
        this.fillPSControlList(IPSDEDataView.class, psDEDataViewList);
        HashMap<String, IPSDEDataView> psDEDataViewMap = new HashMap<String, IPSDEDataView>();
        for (IPSDEDataView iPSDEDataView : psDEDataViewList) {
            String strId;
            if (StringUtils.hasLength((String)strPSDEId) && (iPSDEDataView.getPSAppDataEntity() == null || iPSDEDataView.getPSAppDataEntity().getPSDataEntity() == null || !strPSDEId.equals(strId = this.getPSModelRTServiceSession().getPSModelUniqueTag((IPSModelObject)iPSDEDataView.getPSAppDataEntity().getPSDataEntity())))) continue;
            psDEDataViewMap.put(this.getPSModelRTServiceSession().getPSModelUniqueTag((IPSModelObject)iPSDEDataView), iPSDEDataView);
        }
        psDEDataViewList.clear();
        psDEDataViewList.addAll(psDEDataViewMap.values());
        return psDEDataViewList;
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSDEDataView.class, this.getPSModelObjectList(new PSDEDataViewFilter()), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDEDataView domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        PSDataEntity parentPSModel = (PSDataEntity)this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", PSDEDataViewRTService.getParentId(domain.getId()));
        domain.setPSDEId(parentPSModel.getId());
        domain.setPSDEName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

