/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.psmodel.core.domain.PSDEDataSet;
import net.ibizsys.psmodel.core.filter.PSDEDataSetFilter;
import net.ibizsys.psmodel.core.service.IPSDEDataSetService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSDEDataSetRTService
extends PSModelRTServiceBase<PSDEDataSet, PSDEDataSetFilter>
implements IPSDEDataSetService {
    private static final Log log = LogFactory.getLog(PSDEDataSetRTService.class);

    public PSDEDataSet createDomain() {
        return new PSDEDataSet();
    }

    public PSDEDataSetFilter createFilter() {
        return new PSDEDataSetFilter();
    }

    public PSDEDataSet getDomain(Object params) {
        if (params instanceof PSDEDataSet) {
            return (PSDEDataSet)params;
        }
        return (PSDEDataSet)PSDEDataSetRTService.getMapper().convertValue(params, PSDEDataSet.class);
    }

    public PSDEDataSetFilter getFilter(Object params) {
        if (params instanceof PSDEDataSetFilter) {
            return (PSDEDataSetFilter)params;
        }
        return (PSDEDataSetFilter)PSDEDataSetRTService.getMapper().convertValue(params, PSDEDataSetFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDEDATASET";
        }
        return "PSDEDATASETS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSDEDataSet.class;
    }

    @Override
    protected List<? extends IPSDEDataSet> getPSModelObjectList(PSDEDataSetFilter f) throws Exception {
        Object objPSDEId = f.getFieldCond("psdeid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            objPSDEId = PSDEDataSetRTService.getParentId((IPSModelFilter)f, "PSDATAENTITY");
        }
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            if (this.getPSSystemService().getPSSystem().getAllPSDataEntities() == null) {
                return null;
            }
            ArrayList allPSDEDataSetList = new ArrayList();
            for (IPSDataEntity iPSDataEntity : this.getPSSystemService().getPSSystem().getAllPSDataEntities()) {
                if (iPSDataEntity.getAllPSDEDataSets() == null) continue;
                allPSDEDataSetList.addAll(iPSDataEntity.getAllPSDEDataSets());
            }
            return allPSDEDataSetList;
        }
        return this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), (String)objPSDEId, false).getAllPSDEDataSets();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSDEDataSet.class, this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), PSDEDataSetRTService.getParentId(key), false).getAllPSDEDataSets(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDEDataSet domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", PSDEDataSetRTService.getParentId(domain.getId()));
        domain.setPSDEId(parentPSModel.getId());
        domain.setPSDEName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

