/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.dr.IPSDEDataRelation;
import net.ibizsys.psmodel.core.domain.PSDEDataRelation;
import net.ibizsys.psmodel.core.filter.PSDEDataRelationFilter;
import net.ibizsys.psmodel.core.service.IPSDEDataRelationService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSDEDataRelationRTService
extends PSModelRTServiceBase<PSDEDataRelation, PSDEDataRelationFilter>
implements IPSDEDataRelationService {
    private static final Log log = LogFactory.getLog(PSDEDataRelationRTService.class);

    public PSDEDataRelation createDomain() {
        return new PSDEDataRelation();
    }

    public PSDEDataRelationFilter createFilter() {
        return new PSDEDataRelationFilter();
    }

    public PSDEDataRelation getDomain(Object params) {
        if (params instanceof PSDEDataRelation) {
            return (PSDEDataRelation)params;
        }
        return (PSDEDataRelation)PSDEDataRelationRTService.getMapper().convertValue(params, PSDEDataRelation.class);
    }

    public PSDEDataRelationFilter getFilter(Object params) {
        if (params instanceof PSDEDataRelationFilter) {
            return (PSDEDataRelationFilter)params;
        }
        return (PSDEDataRelationFilter)PSDEDataRelationRTService.getMapper().convertValue(params, PSDEDataRelationFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDEDATARELATION";
        }
        return "PSDEDATARELATIONS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSDEDataRelation.class;
    }

    @Override
    protected List<? extends IPSDEDataRelation> getPSModelObjectList(PSDEDataRelationFilter f) throws Exception {
        Object objPSDEId = f.getFieldCond("psdeid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            objPSDEId = PSDEDataRelationRTService.getParentId((IPSModelFilter)f, "PSDATAENTITY");
        }
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            if (this.getPSSystemService().getPSSystem().getAllPSDataEntities() == null) {
                return null;
            }
            ArrayList allPSDEDataRelationList = new ArrayList();
            for (IPSDataEntity iPSDataEntity : this.getPSSystemService().getPSSystem().getAllPSDataEntities()) {
                if (iPSDataEntity.getAllPSDEDataRelations() == null) continue;
                allPSDEDataRelationList.addAll(iPSDataEntity.getAllPSDEDataRelations());
            }
            return allPSDEDataRelationList;
        }
        return this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), (String)objPSDEId, false).getAllPSDEDataRelations();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSDEDataRelation.class, this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), PSDEDataRelationRTService.getParentId(key), false).getAllPSDEDataRelations(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDEDataRelation domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", PSDEDataRelationRTService.getParentId(domain.getId()));
        domain.setPSDEId(parentPSModel.getId());
        domain.setPSDEName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

