/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.dataexport.IPSDEDataExport;
import net.ibizsys.psmodel.core.domain.PSDEDataExp;
import net.ibizsys.psmodel.core.filter.PSDEDataExpFilter;
import net.ibizsys.psmodel.core.service.IPSDEDataExpService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSDEDataExpRTService
extends PSModelRTServiceBase<PSDEDataExp, PSDEDataExpFilter>
implements IPSDEDataExpService {
    private static final Log log = LogFactory.getLog(PSDEDataExpRTService.class);

    public PSDEDataExp createDomain() {
        return new PSDEDataExp();
    }

    public PSDEDataExpFilter createFilter() {
        return new PSDEDataExpFilter();
    }

    public PSDEDataExp getDomain(Object params) {
        if (params instanceof PSDEDataExp) {
            return (PSDEDataExp)params;
        }
        return (PSDEDataExp)PSDEDataExpRTService.getMapper().convertValue(params, PSDEDataExp.class);
    }

    public PSDEDataExpFilter getFilter(Object params) {
        if (params instanceof PSDEDataExpFilter) {
            return (PSDEDataExpFilter)params;
        }
        return (PSDEDataExpFilter)PSDEDataExpRTService.getMapper().convertValue(params, PSDEDataExpFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDEDATAEXP";
        }
        return "PSDEDATAEXPS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSDEDataExport.class;
    }

    @Override
    protected List<? extends IPSDEDataExport> getPSModelObjectList(PSDEDataExpFilter f) throws Exception {
        Object objPSDEId = f.getFieldCond("psdeid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            objPSDEId = PSDEDataExpRTService.getParentId((IPSModelFilter)f, "PSDATAENTITY");
        }
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            if (this.getPSSystemService().getPSSystem().getAllPSDataEntities() == null) {
                return null;
            }
            ArrayList allPSDEDataExportList = new ArrayList();
            for (IPSDataEntity iPSDataEntity : this.getPSSystemService().getPSSystem().getAllPSDataEntities()) {
                if (iPSDataEntity.getAllPSDEDataExports() == null) continue;
                allPSDEDataExportList.addAll(iPSDataEntity.getAllPSDEDataExports());
            }
            return allPSDEDataExportList;
        }
        return this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), (String)objPSDEId, false).getAllPSDEDataExports();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSDEDataExport.class, this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), PSDEDataExpRTService.getParentId(key), false).getAllPSDEDataExports(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDEDataExp domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", PSDEDataExpRTService.getParentId(domain.getId()));
        domain.setPSDEId(parentPSModel.getId());
        domain.setPSDEName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

