/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.dr.IPSDEDRItem;
import net.ibizsys.psmodel.core.domain.PSDEDRItem;
import net.ibizsys.psmodel.core.filter.PSDEDRItemFilter;
import net.ibizsys.psmodel.core.service.IPSDEDRItemService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSDEDRItemRTService
extends PSModelRTServiceBase<PSDEDRItem, PSDEDRItemFilter>
implements IPSDEDRItemService {
    private static final Log log = LogFactory.getLog(PSDEDRItemRTService.class);

    public PSDEDRItem createDomain() {
        return new PSDEDRItem();
    }

    public PSDEDRItemFilter createFilter() {
        return new PSDEDRItemFilter();
    }

    public PSDEDRItem getDomain(Object params) {
        if (params instanceof PSDEDRItem) {
            return (PSDEDRItem)params;
        }
        return (PSDEDRItem)PSDEDRItemRTService.getMapper().convertValue(params, PSDEDRItem.class);
    }

    public PSDEDRItemFilter getFilter(Object params) {
        if (params instanceof PSDEDRItemFilter) {
            return (PSDEDRItemFilter)params;
        }
        return (PSDEDRItemFilter)PSDEDRItemRTService.getMapper().convertValue(params, PSDEDRItemFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDEDRITEM";
        }
        return "PSDEDRITEMS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSDEDRItem.class;
    }

    @Override
    protected List<? extends IPSDEDRItem> getPSModelObjectList(PSDEDRItemFilter f) throws Exception {
        Object objPSDEId = f.getFieldCond("psdeid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            objPSDEId = PSDEDRItemRTService.getParentId((IPSModelFilter)f, "PSDATAENTITY");
        }
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            if (this.getPSSystemService().getPSSystem().getAllPSDataEntities() == null) {
                return null;
            }
            ArrayList allPSDEDRItemList = new ArrayList();
            for (IPSDataEntity iPSDataEntity : this.getPSSystemService().getPSSystem().getAllPSDataEntities()) {
                if (iPSDataEntity.getAllPSDEDRItems() == null) continue;
                allPSDEDRItemList.addAll(iPSDataEntity.getAllPSDEDRItems());
            }
            return allPSDEDRItemList;
        }
        return this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), (String)objPSDEId, false).getAllPSDEDRItems();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSDEDRItem.class, this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), PSDEDRItemRTService.getParentId(key), false).getAllPSDEDRItems(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDEDRItem domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", PSDEDRItemRTService.getParentId(domain.getId()));
        domain.setPSDEId(parentPSModel.getId());
        domain.setPSDEName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

