/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.psmodel.core.domain.PSDEAction;
import net.ibizsys.psmodel.core.filter.PSDEActionFilter;
import net.ibizsys.psmodel.core.service.IPSDEActionService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSDEActionRTService
extends PSModelRTServiceBase<PSDEAction, PSDEActionFilter>
implements IPSDEActionService {
    private static final Log log = LogFactory.getLog(PSDEActionRTService.class);

    public PSDEAction createDomain() {
        return new PSDEAction();
    }

    public PSDEActionFilter createFilter() {
        return new PSDEActionFilter();
    }

    public PSDEAction getDomain(Object params) {
        if (params instanceof PSDEAction) {
            return (PSDEAction)params;
        }
        return (PSDEAction)PSDEActionRTService.getMapper().convertValue(params, PSDEAction.class);
    }

    public PSDEActionFilter getFilter(Object params) {
        if (params instanceof PSDEActionFilter) {
            return (PSDEActionFilter)params;
        }
        return (PSDEActionFilter)PSDEActionRTService.getMapper().convertValue(params, PSDEActionFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDEACTION";
        }
        return "PSDEACTIONS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSDEAction.class;
    }

    @Override
    protected List<? extends IPSDEAction> getPSModelObjectList(PSDEActionFilter f) throws Exception {
        Object objPSDEId = f.getFieldCond("psdeid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            objPSDEId = PSDEActionRTService.getParentId((IPSModelFilter)f, "PSDATAENTITY");
        }
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            if (this.getPSSystemService().getPSSystem().getAllPSDataEntities() == null) {
                return null;
            }
            ArrayList allPSDEActionList = new ArrayList();
            for (IPSDataEntity iPSDataEntity : this.getPSSystemService().getPSSystem().getAllPSDataEntities()) {
                if (iPSDataEntity.getAllPSDEActions() == null) continue;
                allPSDEActionList.addAll(iPSDataEntity.getAllPSDEActions());
            }
            return allPSDEActionList;
        }
        return this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), (String)objPSDEId, false).getAllPSDEActions();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSDEAction.class, this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), PSDEActionRTService.getParentId(key), false).getAllPSDEActions(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDEAction domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", PSDEActionRTService.getParentId(domain.getId()));
        domain.setPSDEId(parentPSModel.getId());
        domain.setPSDEName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

