/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.action.IPSDEActionLogic;
import net.ibizsys.psmodel.core.domain.PSDEAction;
import net.ibizsys.psmodel.core.domain.PSDEActionLogic;
import net.ibizsys.psmodel.core.filter.PSDEActionLogicFilter;
import net.ibizsys.psmodel.core.service.IPSDEActionLogicService;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSDEActionLogicRTService
extends PSModelRTServiceBase<PSDEActionLogic, PSDEActionLogicFilter>
implements IPSDEActionLogicService {
    private static final Log log = LogFactory.getLog(PSDEActionLogicRTService.class);

    public PSDEActionLogic createDomain() {
        return new PSDEActionLogic();
    }

    public PSDEActionLogicFilter createFilter() {
        return new PSDEActionLogicFilter();
    }

    public PSDEActionLogic getDomain(Object params) {
        if (params instanceof PSDEActionLogic) {
            return (PSDEActionLogic)params;
        }
        return (PSDEActionLogic)PSDEActionLogicRTService.getMapper().convertValue(params, PSDEActionLogic.class);
    }

    public PSDEActionLogicFilter getFilter(Object params) {
        if (params instanceof PSDEActionLogicFilter) {
            return (PSDEActionLogicFilter)params;
        }
        return (PSDEActionLogicFilter)PSDEActionLogicRTService.getMapper().convertValue(params, PSDEActionLogicFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDEACTIONLOGIC";
        }
        return "PSDEACTIONLOGICS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSDEActionLogic.class;
    }

    @Override
    protected List<? extends IPSDEActionLogic> getPSModelObjectList(PSDEActionLogicFilter f) throws Exception {
        Object objPSDEActionId = f.getFieldCond("psdeactionid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEActionId)) {
            objPSDEActionId = PSDEActionLogicRTService.getParentId((IPSModelFilter)f, "PSDEACTION");
        }
        if (ObjectUtils.isEmpty((Object)objPSDEActionId)) {
            if (this.getPSSystemService().getPSSystem().getAllPSDataEntities() == null) {
                return null;
            }
            ArrayList allPSDEActionLogicList = new ArrayList();
            for (IPSDataEntity iPSDataEntity : this.getPSSystemService().getPSSystem().getAllPSDataEntities()) {
                if (iPSDataEntity.getAllPSDEActions() == null) continue;
                for (IPSDEAction iPSDEAction : iPSDataEntity.getAllPSDEActions()) {
                    if (!ObjectUtils.isEmpty((Object)iPSDEAction.getPreparePSDEActionLogics())) {
                        allPSDEActionLogicList.addAll(iPSDEAction.getPreparePSDEActionLogics());
                    }
                    if (!ObjectUtils.isEmpty((Object)iPSDEAction.getCheckPSDEActionLogics())) {
                        allPSDEActionLogicList.addAll(iPSDEAction.getCheckPSDEActionLogics());
                    }
                    if (!ObjectUtils.isEmpty((Object)iPSDEAction.getBeforePSDEActionLogics())) {
                        allPSDEActionLogicList.addAll(iPSDEAction.getBeforePSDEActionLogics());
                    }
                    if (ObjectUtils.isEmpty((Object)iPSDEAction.getAfterPSDEActionLogics())) continue;
                    allPSDEActionLogicList.addAll(iPSDEAction.getAfterPSDEActionLogics());
                }
            }
            return allPSDEActionLogicList;
        }
        String strPSDEId = PSDEActionLogicRTService.getParentId((String)objPSDEActionId);
        IPSDEAction iPSDEAction = this.getPSModelObject(IPSDEAction.class, this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), strPSDEId, false).getAllPSDEActions(), (String)objPSDEActionId, false);
        ArrayList allPSDEActionLogicList = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)iPSDEAction.getPreparePSDEActionLogics())) {
            allPSDEActionLogicList.addAll(iPSDEAction.getPreparePSDEActionLogics());
        }
        if (!ObjectUtils.isEmpty((Object)iPSDEAction.getCheckPSDEActionLogics())) {
            allPSDEActionLogicList.addAll(iPSDEAction.getCheckPSDEActionLogics());
        }
        if (!ObjectUtils.isEmpty((Object)iPSDEAction.getBeforePSDEActionLogics())) {
            allPSDEActionLogicList.addAll(iPSDEAction.getBeforePSDEActionLogics());
        }
        if (!ObjectUtils.isEmpty((Object)iPSDEAction.getAfterPSDEActionLogics())) {
            allPSDEActionLogicList.addAll(iPSDEAction.getAfterPSDEActionLogics());
        }
        return allPSDEActionLogicList;
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        String strPSDEActionId = PSDEActionLogicRTService.getParentId(key);
        String strPSDEId = PSDEActionLogicRTService.getParentId(strPSDEActionId);
        IPSDEAction iPSDEAction = this.getPSModelObject(IPSDEAction.class, this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), strPSDEId, false).getAllPSDEActions(), strPSDEActionId, false);
        ArrayList allPSDEActionLogicList = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)iPSDEAction.getPreparePSDEActionLogics())) {
            allPSDEActionLogicList.addAll(iPSDEAction.getPreparePSDEActionLogics());
        }
        if (!ObjectUtils.isEmpty((Object)iPSDEAction.getCheckPSDEActionLogics())) {
            allPSDEActionLogicList.addAll(iPSDEAction.getCheckPSDEActionLogics());
        }
        if (!ObjectUtils.isEmpty((Object)iPSDEAction.getBeforePSDEActionLogics())) {
            allPSDEActionLogicList.addAll(iPSDEAction.getBeforePSDEActionLogics());
        }
        if (!ObjectUtils.isEmpty((Object)iPSDEAction.getAfterPSDEActionLogics())) {
            allPSDEActionLogicList.addAll(iPSDEAction.getAfterPSDEActionLogics());
        }
        return this.getPSModelObject(IPSDEActionLogic.class, allPSDEActionLogicList, key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDEActionLogic domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        int nPos;
        PSDEAction parentPSModel = (PSDEAction)this.getPSModelRTServiceSession().getCachePSModel("PSDEACTION", PSDEActionLogicRTService.getParentId(domain.getId()));
        domain.setPSDEActionId(parentPSModel.getId());
        domain.setPSDEActionName(parentPSModel.getName());
        domain.setPSDEId(parentPSModel.getPSDEId());
        domain.setPSDEName(parentPSModel.getPSDEName());
        IPSDEAction iPSDEAction = (IPSDEAction)iPSModelObject.getParentPSModelObject(IPSDEAction.class, false);
        if (!ObjectUtils.isEmpty((Object)iPSDEAction.getPreparePSDEActionLogics()) && (nPos = iPSDEAction.getPreparePSDEActionLogics().indexOf(iPSModelObject)) != -1) {
            domain.setOrderValue(Integer.valueOf((nPos + 1) * 100));
            domain.setCodeName(String.format("prepare%1$s", domain.getOrderValue()));
        }
        if (!ObjectUtils.isEmpty((Object)iPSDEAction.getCheckPSDEActionLogics()) && (nPos = iPSDEAction.getCheckPSDEActionLogics().indexOf(iPSModelObject)) != -1) {
            domain.setOrderValue(Integer.valueOf((nPos + 1) * 100));
            domain.setCodeName(String.format("check%1$s", domain.getOrderValue()));
        }
        if (!ObjectUtils.isEmpty((Object)iPSDEAction.getBeforePSDEActionLogics()) && (nPos = iPSDEAction.getBeforePSDEActionLogics().indexOf(iPSModelObject)) != -1) {
            domain.setOrderValue(Integer.valueOf((nPos + 1) * 100));
            domain.setCodeName(String.format("before%1$s", domain.getOrderValue()));
        }
        if (!ObjectUtils.isEmpty((Object)iPSDEAction.getAfterPSDEActionLogics()) && (nPos = iPSDEAction.getAfterPSDEActionLogics().indexOf(iPSModelObject)) != -1) {
            domain.setOrderValue(Integer.valueOf((nPos + 1) * 100));
            domain.setCodeName(String.format("after%1$s", domain.getOrderValue()));
        }
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

