/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.model.app.view.IPSAppView;
import net.ibizsys.psmodel.core.domain.PSAppView;
import net.ibizsys.psmodel.core.filter.PSAppViewFilter;
import net.ibizsys.psmodel.core.service.IPSAppViewService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSAppViewRTService
extends PSModelRTServiceBase<PSAppView, PSAppViewFilter>
implements IPSAppViewService<PSAppView, PSAppViewFilter> {
    private static final Log log = LogFactory.getLog(PSAppViewRTService.class);

    public PSAppView createDomain() {
        return null;
    }

    public PSAppViewFilter createFilter() {
        return new PSAppViewFilter();
    }

    public PSAppView getDomain(Object params) {
        if (params instanceof PSAppView) {
            return (PSAppView)params;
        }
        return (PSAppView)PSAppViewRTService.getMapper().convertValue(params, PSAppView.class);
    }

    public PSAppViewFilter getFilter(Object params) {
        if (params instanceof PSAppViewFilter) {
            return (PSAppViewFilter)params;
        }
        return (PSAppViewFilter)PSAppViewRTService.getMapper().convertValue(params, PSAppViewFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSAPPVIEW";
        }
        return "PSAPPVIEWS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSAppView.class;
    }

    @Override
    protected List<? extends IPSAppView> getPSModelObjectList(PSAppViewFilter f) throws Exception {
        Object objPSSysAppId = f.getFieldCond("pssysappid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSSysAppId)) {
            objPSSysAppId = PSAppViewRTService.getParentId((IPSModelFilter)f, "PSSYSAPP");
        }
        if (ObjectUtils.isEmpty((Object)objPSSysAppId)) {
            ArrayList allPSAppViewList = new ArrayList();
            if (!ObjectUtils.isEmpty((Object)this.getPSSystemService().getPSSystem().getAllPSApps())) {
                for (IPSApplication iPSApplication : this.getPSSystemService().getPSSystem().getAllPSApps()) {
                    if (iPSApplication.getAllPSAppViews() == null) continue;
                    allPSAppViewList.addAll(iPSApplication.getAllPSAppViews());
                }
            }
            return allPSAppViewList;
        }
        return this.getPSModelObject(IPSApplication.class, this.getPSSystemService().getPSSystem().getAllPSApps(), (String)objPSSysAppId, false).getAllPSAppViews();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSAppView.class, this.getPSModelObject(IPSApplication.class, this.getPSSystemService().getPSSystem().getAllPSApps(), PSAppViewRTService.getParentId(key), false).getAllPSAppViews(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSAppView domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSSYSAPP", PSAppViewRTService.getParentId(domain.getId()));
        domain.setPSSysAppId(parentPSModel.getId());
        domain.setPSSysAppName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

