/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.model.app.view.IPSAppView;
import net.ibizsys.psmodel.core.domain.PSAppUtilView;
import net.ibizsys.psmodel.core.filter.PSAppUtilViewFilter;
import net.ibizsys.psmodel.core.service.IPSAppUtilViewService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSAppUtilViewRTService
extends PSModelRTServiceBase<PSAppUtilView, PSAppUtilViewFilter>
implements IPSAppUtilViewService {
    private static final Log log = LogFactory.getLog(PSAppUtilViewRTService.class);

    public PSAppUtilView createDomain() {
        return new PSAppUtilView();
    }

    public PSAppUtilViewFilter createFilter() {
        return new PSAppUtilViewFilter();
    }

    public PSAppUtilView getDomain(Object params) {
        if (params instanceof PSAppUtilView) {
            return (PSAppUtilView)params;
        }
        return (PSAppUtilView)PSAppUtilViewRTService.getMapper().convertValue(params, PSAppUtilView.class);
    }

    public PSAppUtilViewFilter getFilter(Object params) {
        if (params instanceof PSAppUtilViewFilter) {
            return (PSAppUtilViewFilter)params;
        }
        return (PSAppUtilViewFilter)PSAppUtilViewRTService.getMapper().convertValue(params, PSAppUtilViewFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSAPPUTILVIEW";
        }
        return "PSAPPUTILVIEWS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSAppView.class;
    }

    @Override
    protected List<? extends IPSAppView> getPSModelObjectList(PSAppUtilViewFilter f) throws Exception {
        Object objPSSysAppId = f.getFieldCond("pssysappid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSSysAppId) && ObjectUtils.isEmpty((Object)(objPSSysAppId = PSAppUtilViewRTService.getParentId((IPSModelFilter)f, "PSSYSAPP")))) {
            throw new Exception("\u672a\u6307\u5b9a\u5e94\u7528\u6807\u8bc6");
        }
        return this.getPSModelObject(IPSApplication.class, this.getPSSystemService().getPSSystem().getAllPSApps(), (String)objPSSysAppId, false).getAllPSAppViews();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSAppView.class, this.getPSModelObject(IPSApplication.class, this.getPSSystemService().getPSSystem().getAllPSApps(), PSAppUtilViewRTService.getParentId(key), false).getAllPSAppViews(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSAppUtilView domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSSYSAPP", PSAppUtilViewRTService.getParentId(domain.getId()));
        domain.setPSSysAppId(parentPSModel.getId());
        domain.setPSSysAppName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

