/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.model.app.util.IPSAppUtil;
import net.ibizsys.psmodel.core.domain.PSAppUtil;
import net.ibizsys.psmodel.core.filter.PSAppUtilFilter;
import net.ibizsys.psmodel.core.service.IPSAppUtilService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSAppUtilRTService
extends PSModelRTServiceBase<PSAppUtil, PSAppUtilFilter>
implements IPSAppUtilService {
    private static final Log log = LogFactory.getLog(PSAppUtilRTService.class);

    public PSAppUtil createDomain() {
        return new PSAppUtil();
    }

    public PSAppUtilFilter createFilter() {
        return new PSAppUtilFilter();
    }

    public PSAppUtil getDomain(Object params) {
        if (params instanceof PSAppUtil) {
            return (PSAppUtil)params;
        }
        return (PSAppUtil)PSAppUtilRTService.getMapper().convertValue(params, PSAppUtil.class);
    }

    public PSAppUtilFilter getFilter(Object params) {
        if (params instanceof PSAppUtilFilter) {
            return (PSAppUtilFilter)params;
        }
        return (PSAppUtilFilter)PSAppUtilRTService.getMapper().convertValue(params, PSAppUtilFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSAPPUTIL";
        }
        return "PSAPPUTILS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSAppUtil.class;
    }

    @Override
    protected List<? extends IPSAppUtil> getPSModelObjectList(PSAppUtilFilter f) throws Exception {
        Object objPSSysAppId = f.getFieldCond("pssysappid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSSysAppId) && ObjectUtils.isEmpty((Object)(objPSSysAppId = PSAppUtilRTService.getParentId((IPSModelFilter)f, "PSSYSAPP")))) {
            throw new Exception("\u672a\u6307\u5b9a\u5e94\u7528\u6807\u8bc6");
        }
        return this.getPSModelObject(IPSApplication.class, this.getPSSystemService().getPSSystem().getAllPSApps(), (String)objPSSysAppId, false).getAllPSAppUtils();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSAppUtil.class, this.getPSModelObject(IPSApplication.class, this.getPSSystemService().getPSSystem().getAllPSApps(), PSAppUtilRTService.getParentId(key), false).getAllPSAppUtils(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSAppUtil domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSSYSAPP", PSAppUtilRTService.getParentId(domain.getId()));
        domain.setPSSysAppId(parentPSModel.getId());
        domain.setPSSysAppName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

