/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.model.app.view.IPSAppView;
import net.ibizsys.psmodel.core.domain.PSAppPortalView;
import net.ibizsys.psmodel.core.filter.PSAppPortalViewFilter;
import net.ibizsys.psmodel.core.service.IPSAppPortalViewService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSAppPortalViewRTService
extends PSModelRTServiceBase<PSAppPortalView, PSAppPortalViewFilter>
implements IPSAppPortalViewService {
    private static final Log log = LogFactory.getLog(PSAppPortalViewRTService.class);

    public PSAppPortalView createDomain() {
        return new PSAppPortalView();
    }

    public PSAppPortalViewFilter createFilter() {
        return new PSAppPortalViewFilter();
    }

    public PSAppPortalView getDomain(Object params) {
        if (params instanceof PSAppPortalView) {
            return (PSAppPortalView)params;
        }
        return (PSAppPortalView)PSAppPortalViewRTService.getMapper().convertValue(params, PSAppPortalView.class);
    }

    public PSAppPortalViewFilter getFilter(Object params) {
        if (params instanceof PSAppPortalViewFilter) {
            return (PSAppPortalViewFilter)params;
        }
        return (PSAppPortalViewFilter)PSAppPortalViewRTService.getMapper().convertValue(params, PSAppPortalViewFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSAPPPORTALVIEW";
        }
        return "PSAPPPORTALVIEWS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSAppView.class;
    }

    @Override
    protected List<? extends IPSAppView> getPSModelObjectList(PSAppPortalViewFilter f) throws Exception {
        Object objPSSysAppId = f.getFieldCond("pssysappid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSSysAppId) && ObjectUtils.isEmpty((Object)(objPSSysAppId = PSAppPortalViewRTService.getParentId((IPSModelFilter)f, "PSSYSAPP")))) {
            throw new Exception("\u672a\u6307\u5b9a\u5e94\u7528\u6807\u8bc6");
        }
        return this.getPSModelObject(IPSApplication.class, this.getPSSystemService().getPSSystem().getAllPSApps(), (String)objPSSysAppId, false).getAllPSAppViews();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSAppView.class, this.getPSModelObject(IPSApplication.class, this.getPSSystemService().getPSSystem().getAllPSApps(), PSAppPortalViewRTService.getParentId(key), false).getAllPSAppViews(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSAppPortalView domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSSYSAPP", PSAppPortalViewRTService.getParentId(domain.getId()));
        domain.setPSSysAppId(parentPSModel.getId());
        domain.setPSSysAppName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

