/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.model.app.appmenu.IPSAppMenuModel;
import net.ibizsys.psmodel.core.domain.PSAppMenu;
import net.ibizsys.psmodel.core.filter.PSAppMenuFilter;
import net.ibizsys.psmodel.core.service.IPSAppMenuService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSAppMenuRTService
extends PSModelRTServiceBase<PSAppMenu, PSAppMenuFilter>
implements IPSAppMenuService {
    private static final Log log = LogFactory.getLog(PSAppMenuRTService.class);

    public PSAppMenu createDomain() {
        return new PSAppMenu();
    }

    public PSAppMenuFilter createFilter() {
        return new PSAppMenuFilter();
    }

    public PSAppMenu getDomain(Object params) {
        if (params instanceof PSAppMenu) {
            return (PSAppMenu)params;
        }
        return (PSAppMenu)PSAppMenuRTService.getMapper().convertValue(params, PSAppMenu.class);
    }

    public PSAppMenuFilter getFilter(Object params) {
        if (params instanceof PSAppMenuFilter) {
            return (PSAppMenuFilter)params;
        }
        return (PSAppMenuFilter)PSAppMenuRTService.getMapper().convertValue(params, PSAppMenuFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSAPPMENU";
        }
        return "PSAPPMENUS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSAppMenuModel.class;
    }

    @Override
    protected List<? extends IPSAppMenuModel> getPSModelObjectList(PSAppMenuFilter f) throws Exception {
        Object objPSSysAppId = f.getFieldCond("pssysappid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSSysAppId) && ObjectUtils.isEmpty((Object)(objPSSysAppId = PSAppMenuRTService.getParentId((IPSModelFilter)f, "PSSYSAPP")))) {
            throw new Exception("\u672a\u6307\u5b9a\u5e94\u7528\u6807\u8bc6");
        }
        return this.getPSModelObject(IPSApplication.class, this.getPSSystemService().getPSSystem().getAllPSApps(), (String)objPSSysAppId, false).getAllPSAppMenuModels();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSAppMenuModel.class, this.getPSModelObject(IPSApplication.class, this.getPSSystemService().getPSSystem().getAllPSApps(), PSAppMenuRTService.getParentId(key), false).getAllPSAppMenuModels(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSAppMenu domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSSYSAPP", PSAppMenuRTService.getParentId(domain.getId()));
        domain.setPSSysAppId(parentPSModel.getId());
        domain.setPSSysAppName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

