/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.app.IPSAppLogic;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.psmodel.core.domain.PSAppLogic;
import net.ibizsys.psmodel.core.filter.PSAppLogicFilter;
import net.ibizsys.psmodel.core.service.IPSAppLogicService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSAppLogicRTService
extends PSModelRTServiceBase<PSAppLogic, PSAppLogicFilter>
implements IPSAppLogicService {
    private static final Log log = LogFactory.getLog(PSAppLogicRTService.class);

    public PSAppLogic createDomain() {
        return new PSAppLogic();
    }

    public PSAppLogicFilter createFilter() {
        return new PSAppLogicFilter();
    }

    public PSAppLogic getDomain(Object params) {
        if (params instanceof PSAppLogic) {
            return (PSAppLogic)params;
        }
        return (PSAppLogic)PSAppLogicRTService.getMapper().convertValue(params, PSAppLogic.class);
    }

    public PSAppLogicFilter getFilter(Object params) {
        if (params instanceof PSAppLogicFilter) {
            return (PSAppLogicFilter)params;
        }
        return (PSAppLogicFilter)PSAppLogicRTService.getMapper().convertValue(params, PSAppLogicFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSAPPLOGIC";
        }
        return "PSAPPLOGICS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSAppLogic.class;
    }

    @Override
    protected List<? extends IPSAppLogic> getPSModelObjectList(PSAppLogicFilter f) throws Exception {
        Object objPSSysAppId = f.getFieldCond("pssysappid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSSysAppId) && ObjectUtils.isEmpty((Object)(objPSSysAppId = PSAppLogicRTService.getParentId((IPSModelFilter)f, "PSSYSAPP")))) {
            throw new Exception("\u672a\u6307\u5b9a\u5e94\u7528\u6807\u8bc6");
        }
        return this.getPSModelObject(IPSApplication.class, this.getPSSystemService().getPSSystem().getAllPSApps(), (String)objPSSysAppId, false).getAllPSAppLogics();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSAppLogic.class, this.getPSModelObject(IPSApplication.class, this.getPSSystemService().getPSSystem().getAllPSApps(), PSAppLogicRTService.getParentId(key), false).getAllPSAppLogics(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSAppLogic domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSSYSAPP", PSAppLogicRTService.getParentId(domain.getId()));
        domain.setPSSysAppId(parentPSModel.getId());
        domain.setPSSysAppName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

