/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.model.app.func.IPSAppFunc;
import net.ibizsys.psmodel.core.domain.PSAppFunc;
import net.ibizsys.psmodel.core.filter.PSAppFuncFilter;
import net.ibizsys.psmodel.core.service.IPSAppFuncService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSAppFuncRTService
extends PSModelRTServiceBase<PSAppFunc, PSAppFuncFilter>
implements IPSAppFuncService {
    private static final Log log = LogFactory.getLog(PSAppFuncRTService.class);

    public PSAppFunc createDomain() {
        return new PSAppFunc();
    }

    public PSAppFuncFilter createFilter() {
        return new PSAppFuncFilter();
    }

    public PSAppFunc getDomain(Object params) {
        if (params instanceof PSAppFunc) {
            return (PSAppFunc)params;
        }
        return (PSAppFunc)PSAppFuncRTService.getMapper().convertValue(params, PSAppFunc.class);
    }

    public PSAppFuncFilter getFilter(Object params) {
        if (params instanceof PSAppFuncFilter) {
            return (PSAppFuncFilter)params;
        }
        return (PSAppFuncFilter)PSAppFuncRTService.getMapper().convertValue(params, PSAppFuncFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSAPPFUNC";
        }
        return "PSAPPFUNCS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSAppFunc.class;
    }

    @Override
    protected List<? extends IPSAppFunc> getPSModelObjectList(PSAppFuncFilter f) throws Exception {
        Object objPSSysAppId = f.getFieldCond("pssysappid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSSysAppId) && ObjectUtils.isEmpty((Object)(objPSSysAppId = PSAppFuncRTService.getParentId((IPSModelFilter)f, "PSSYSAPP")))) {
            throw new Exception("\u672a\u6307\u5b9a\u5e94\u7528\u6807\u8bc6");
        }
        return this.getPSModelObject(IPSApplication.class, this.getPSSystemService().getPSSystem().getAllPSApps(), (String)objPSSysAppId, false).getAllPSAppFuncs();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSAppFunc.class, this.getPSModelObject(IPSApplication.class, this.getPSSystemService().getPSSystem().getAllPSApps(), PSAppFuncRTService.getParentId(key), false).getAllPSAppFuncs(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSAppFunc domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSSYSAPP", PSAppFuncRTService.getParentId(domain.getId()));
        domain.setPSSysAppId(parentPSModel.getId());
        domain.setPSSysAppName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

