/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.model.app.view.IPSAppView;
import net.ibizsys.psmodel.core.domain.PSAppDEView;
import net.ibizsys.psmodel.core.filter.PSAppDEViewFilter;
import net.ibizsys.psmodel.core.service.IPSAppDEViewService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSAppDEViewRTService
extends PSModelRTServiceBase<PSAppDEView, PSAppDEViewFilter>
implements IPSAppDEViewService {
    private static final Log log = LogFactory.getLog(PSAppDEViewRTService.class);

    public PSAppDEView createDomain() {
        return new PSAppDEView();
    }

    public PSAppDEViewFilter createFilter() {
        return new PSAppDEViewFilter();
    }

    public PSAppDEView getDomain(Object params) {
        if (params instanceof PSAppDEView) {
            return (PSAppDEView)params;
        }
        return (PSAppDEView)PSAppDEViewRTService.getMapper().convertValue(params, PSAppDEView.class);
    }

    public PSAppDEViewFilter getFilter(Object params) {
        if (params instanceof PSAppDEViewFilter) {
            return (PSAppDEViewFilter)params;
        }
        return (PSAppDEViewFilter)PSAppDEViewRTService.getMapper().convertValue(params, PSAppDEViewFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSAPPDEVIEW";
        }
        return "PSAPPDEVIEWS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSAppView.class;
    }

    @Override
    protected List<? extends IPSAppView> getPSModelObjectList(PSAppDEViewFilter f) throws Exception {
        Object objPSSysAppId = f.getFieldCond("pssysappid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSSysAppId) && ObjectUtils.isEmpty((Object)(objPSSysAppId = PSAppDEViewRTService.getParentId((IPSModelFilter)f, "PSSYSAPP")))) {
            throw new Exception("\u672a\u6307\u5b9a\u5e94\u7528\u6807\u8bc6");
        }
        return this.getPSModelObject(IPSApplication.class, this.getPSSystemService().getPSSystem().getAllPSApps(), (String)objPSSysAppId, false).getAllPSAppViews();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSAppView.class, this.getPSModelObject(IPSApplication.class, this.getPSSystemService().getPSSystem().getAllPSApps(), PSAppDEViewRTService.getParentId(key), false).getAllPSAppViews(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSAppDEView domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSSYSAPP", PSAppDEViewRTService.getParentId(domain.getId()));
        domain.setPSSysAppId(parentPSModel.getId());
        domain.setPSSysAppName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

