/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.wf.IPSWFVersion;
import net.ibizsys.model.wf.IPSWorkflow;
import net.ibizsys.psmodel.core.domain.PSWFVersion;
import net.ibizsys.psmodel.core.domain.PSWorkflow;
import net.ibizsys.psmodel.core.filter.PSWFVersionFilter;
import net.ibizsys.psmodel.core.service.IPSWFVersionService;
import net.ibizsys.psmodel.core.util.DataTypeUtils;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class PSWFVersionRTService
extends PSModelRTServiceBase<PSWFVersion, PSWFVersionFilter>
implements IPSWFVersionService {
    private static final Log log = LogFactory.getLog(PSWFVersionRTService.class);

    public PSWFVersion createDomain() {
        return new PSWFVersion();
    }

    public PSWFVersionFilter createFilter() {
        return new PSWFVersionFilter();
    }

    public PSWFVersion getDomain(Object params) {
        if (params instanceof PSWFVersion) {
            return (PSWFVersion)params;
        }
        return (PSWFVersion)PSWFVersionRTService.getMapper().convertValue(params, PSWFVersion.class);
    }

    public PSWFVersionFilter getFilter(Object params) {
        if (params instanceof PSWFVersionFilter) {
            return (PSWFVersionFilter)params;
        }
        return (PSWFVersionFilter)PSWFVersionRTService.getMapper().convertValue(params, PSWFVersionFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSWFVERSION";
        }
        return "PSWFVERSIONS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSWFVersion.class;
    }

    @Override
    protected List<? extends IPSWFVersion> getPSModelObjectList(PSWFVersionFilter f) throws Exception {
        Object objPSWFId = f.getFieldCond("pswfid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSWFId) && ObjectUtils.isEmpty((Object)(objPSWFId = PSWFVersionRTService.getParentId((IPSModelFilter)f, "PSWORKFLOW")))) {
            throw new Exception("\u672a\u6307\u5b9a\u5de5\u4f5c\u6d41\u6807\u8bc6");
        }
        return this.getPSModelObject(IPSWorkflow.class, this.getPSSystemService().getPSSystem().getAllPSWorkflows(), (String)objPSWFId, false).getPSWFVersions();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSWFVersion.class, this.getPSModelObject(IPSWorkflow.class, this.getPSSystemService().getPSSystem().getAllPSWorkflows(), PSWFVersionRTService.getParentId(key), false).getPSWFVersions(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSWFVersion domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSWORKFLOW", PSWFVersionRTService.getParentId(domain.getId()));
        domain.setPSWFId(parentPSModel.getId());
        domain.setPSWFName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }

    protected void onBeforeCreate(PSWFVersion m) throws Exception {
        if (!StringUtils.hasLength((String)m.getPSWFId())) {
            throw new Exception("\u672a\u4f20\u5165\u5de5\u4f5c\u6d41\u6807\u8bc6");
        }
        PSWorkflow psWorkflow = (PSWorkflow)this.getPSModelRTServiceSession().getCachePSModel("PSWORKFLOW", m.getPSWFId());
        PSWFVersionFilter psWFVersionFilter = new PSWFVersionFilter();
        psWFVersionFilter.pswfid__eq(m.getPSWFId());
        List psWFVersionList = this.select((IPSModelFilter)psWFVersionFilter);
        int nMaxVersion = 0;
        if (!ObjectUtils.isEmpty((Object)psWFVersionList)) {
            for (PSWFVersion psWFVersion : psWFVersionList) {
                int nCurVersion = DataTypeUtils.getIntegerValue((Object)psWFVersion.getWFVersion(), (Integer)1);
                if (nCurVersion <= nMaxVersion) continue;
                nMaxVersion = nCurVersion;
            }
        }
        m.setPSWFVersionId(String.format("%1$s.%2$sv%3$s", psWorkflow.getPSWorkflowId(), psWorkflow.getCodeName(), ++nMaxVersion));
        m.setPSWFVersionName(String.format("%1$s v%2$s", psWorkflow.getPSWorkflowName(), nMaxVersion));
        m.setPSWFName(psWorkflow.getPSWorkflowName());
        m.setWFVersion(Integer.valueOf(nMaxVersion));
        m.set("codename", (Object)String.format("%1$sv%2$s", psWorkflow.getCodeName(), nMaxVersion));
        super.onBeforeCreate((IPSModel)m);
    }
}

