/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.database.IPSSysDBColumn;
import net.ibizsys.model.database.IPSSysDBScheme;
import net.ibizsys.model.database.IPSSysDBTable;
import net.ibizsys.psmodel.core.domain.PSSysDBColumn;
import net.ibizsys.psmodel.core.domain.PSSysDBTable;
import net.ibizsys.psmodel.core.filter.PSSysDBColumnFilter;
import net.ibizsys.psmodel.core.service.IPSSysDBColumnService;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSSysDBColumnRTService
extends PSModelRTServiceBase<PSSysDBColumn, PSSysDBColumnFilter>
implements IPSSysDBColumnService {
    private static final Log log = LogFactory.getLog(PSSysDBColumnRTService.class);

    public PSSysDBColumn createDomain() {
        return new PSSysDBColumn();
    }

    public PSSysDBColumnFilter createFilter() {
        return new PSSysDBColumnFilter();
    }

    public PSSysDBColumn getDomain(Object params) {
        if (params instanceof PSSysDBColumn) {
            return (PSSysDBColumn)params;
        }
        return (PSSysDBColumn)PSSysDBColumnRTService.getMapper().convertValue(params, PSSysDBColumn.class);
    }

    public PSSysDBColumnFilter getFilter(Object params) {
        if (params instanceof PSSysDBColumnFilter) {
            return (PSSysDBColumnFilter)params;
        }
        return (PSSysDBColumnFilter)PSSysDBColumnRTService.getMapper().convertValue(params, PSSysDBColumnFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSSYSDBCOLUMN";
        }
        return "PSSYSDBCOLUMNS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSSysDBColumn.class;
    }

    @Override
    protected List<? extends IPSSysDBColumn> getPSModelObjectList(PSSysDBColumnFilter f) throws Exception {
        Object objPSSysDBTableId = f.getFieldCond("pssysdbtableid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSSysDBTableId)) {
            objPSSysDBTableId = PSSysDBColumnRTService.getParentId((IPSModelFilter)f, "PSSYSDBTABLE");
        }
        Object objPSSysDBSchemeId = null;
        if (ObjectUtils.isEmpty((Object)objPSSysDBTableId) && ObjectUtils.isEmpty((Object)(objPSSysDBSchemeId = f.getFieldCond("pssysdbschemeid", "EQ")))) {
            objPSSysDBSchemeId = PSSysDBColumnRTService.getParentId((IPSModelFilter)f, "PSSYSDBSCHEME");
        }
        if (ObjectUtils.isEmpty((Object)objPSSysDBTableId)) {
            if (this.getPSSystemService().getPSSystem().getAllPSSysDBSchemes() == null) {
                return null;
            }
            ArrayList allPSSysDBColumnList = new ArrayList();
            for (IPSSysDBScheme iPSSysDBScheme : this.getPSSystemService().getPSSystem().getAllPSSysDBSchemes()) {
                if (!ObjectUtils.isEmpty((Object)objPSSysDBSchemeId) && !this.getPSModelRTServiceSession().getPSModelUniqueTag((IPSModelObject)iPSSysDBScheme).equals(objPSSysDBSchemeId) || ObjectUtils.isEmpty((Object)iPSSysDBScheme.getAllPSSysDBTables())) continue;
                for (IPSSysDBTable iPSSysDBTable : iPSSysDBScheme.getAllPSSysDBTables()) {
                    if (ObjectUtils.isEmpty((Object)iPSSysDBTable.getAllPSSysDBColumns())) continue;
                    allPSSysDBColumnList.addAll(iPSSysDBTable.getAllPSSysDBColumns());
                }
            }
            return allPSSysDBColumnList;
        }
        return this.getPSModelObject(IPSSysDBTable.class, this.getPSModelObject(IPSSysDBScheme.class, this.getPSSystemService().getPSSystem().getAllPSSysDBSchemes(), PSSysDBColumnRTService.getParentId((String)objPSSysDBTableId), false).getAllPSSysDBTables(), (String)objPSSysDBTableId, false).getAllPSSysDBColumns();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        String strPSSysDBTableId = PSSysDBColumnRTService.getParentId(key);
        return this.getPSModelObject(IPSSysDBColumn.class, this.getPSModelObject(IPSSysDBTable.class, this.getPSModelObject(IPSSysDBScheme.class, this.getPSSystemService().getPSSystem().getAllPSSysDBSchemes(), PSSysDBColumnRTService.getParentId(strPSSysDBTableId), false).getAllPSSysDBTables(), strPSSysDBTableId, false).getAllPSSysDBColumns(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSSysDBColumn domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        PSSysDBTable parentPSModel = (PSSysDBTable)this.getPSModelRTServiceSession().getCachePSModel("PSSYSDBTABLE", PSSysDBColumnRTService.getParentId(domain.getId()));
        domain.setPSSysDBTableId(parentPSModel.getId());
        domain.setPSSysDBTableName(parentPSModel.getName());
        domain.setPSSysDBSchemeId(parentPSModel.getPSSysDBSchemeId());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

