/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.service.IPSSubSysServiceAPI;
import net.ibizsys.model.service.IPSSubSysServiceAPIDE;
import net.ibizsys.psmodel.core.domain.PSSubSysSADE;
import net.ibizsys.psmodel.core.filter.PSSubSysSADEFilter;
import net.ibizsys.psmodel.core.service.IPSSubSysSADEService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSSubSysSADERTService
extends PSModelRTServiceBase<PSSubSysSADE, PSSubSysSADEFilter>
implements IPSSubSysSADEService {
    private static final Log log = LogFactory.getLog(PSSubSysSADERTService.class);

    public PSSubSysSADE createDomain() {
        return new PSSubSysSADE();
    }

    public PSSubSysSADEFilter createFilter() {
        return new PSSubSysSADEFilter();
    }

    public PSSubSysSADE getDomain(Object params) {
        if (params instanceof PSSubSysSADE) {
            return (PSSubSysSADE)params;
        }
        return (PSSubSysSADE)PSSubSysSADERTService.getMapper().convertValue(params, PSSubSysSADE.class);
    }

    public PSSubSysSADEFilter getFilter(Object params) {
        if (params instanceof PSSubSysSADEFilter) {
            return (PSSubSysSADEFilter)params;
        }
        return (PSSubSysSADEFilter)PSSubSysSADERTService.getMapper().convertValue(params, PSSubSysSADEFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSSUBSYSSADE";
        }
        return "PSSUBSYSSADES";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSSubSysServiceAPIDE.class;
    }

    @Override
    protected List<? extends IPSSubSysServiceAPIDE> getPSModelObjectList(PSSubSysSADEFilter f) throws Exception {
        Object objPSSubSysServiceAPIId = f.getFieldCond("pssubsysserviceapiid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSSubSysServiceAPIId)) {
            objPSSubSysServiceAPIId = PSSubSysSADERTService.getParentId((IPSModelFilter)f, "PSSUBSYSSERVICEAPI");
        }
        if (ObjectUtils.isEmpty((Object)objPSSubSysServiceAPIId)) {
            List psSysServiceAPIList = this.getPSSystemService().getPSSystem().getAllPSSubSysServiceAPIs();
            if (ObjectUtils.isEmpty((Object)psSysServiceAPIList)) {
                return null;
            }
            ArrayList psDEServiceAPIList = new ArrayList();
            for (IPSSubSysServiceAPI iPSSubSysServiceAPI : psSysServiceAPIList) {
                if (ObjectUtils.isEmpty((Object)iPSSubSysServiceAPI.getAllPSSubSysServiceAPIDEs())) continue;
                psDEServiceAPIList.addAll(iPSSubSysServiceAPI.getAllPSSubSysServiceAPIDEs());
            }
            return psDEServiceAPIList;
        }
        return this.getPSModelObject(IPSSubSysServiceAPI.class, this.getPSSystemService().getPSSystem().getAllPSSubSysServiceAPIs(), (String)objPSSubSysServiceAPIId, false).getAllPSSubSysServiceAPIDEs();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSSubSysServiceAPIDE.class, this.getPSModelObject(IPSSubSysServiceAPI.class, this.getPSSystemService().getPSSystem().getAllPSSubSysServiceAPIs(), PSSubSysSADERTService.getParentId(key), false).getAllPSSubSysServiceAPIDEs(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSSubSysSADE domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSSUBSYSSERVICEAPI", PSSubSysSADERTService.getParentId(domain.getId()));
        domain.setPSSubSysServiceAPIId(parentPSModel.getId());
        domain.setPSSubSysServiceAPIName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

