/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.model.app.view.IPSAppDEView;
import net.ibizsys.model.app.view.IPSAppView;
import net.ibizsys.model.control.IPSControl;
import net.ibizsys.model.control.calendar.IPSSysCalendar;
import net.ibizsys.model.control.form.IPSDEForm;
import net.ibizsys.model.control.form.IPSDESearchForm;
import net.ibizsys.model.control.grid.IPSDEGrid;
import net.ibizsys.model.control.toolbar.IPSDEToolbar;
import net.ibizsys.model.util.transpiler.IPSModelTranspileContext;
import net.ibizsys.psmodel.core.domain.PSAppDEView;
import net.ibizsys.psmodel.core.domain.PSAppView;
import net.ibizsys.psmodel.core.domain.PSDEViewBase;
import net.ibizsys.psmodel.core.domain.PSDEViewCtrl;
import net.ibizsys.psmodel.core.domain.PSDataEntity;
import net.ibizsys.psmodel.core.filter.PSDEViewBaseFilter;
import net.ibizsys.psmodel.core.service.IPSDEViewBaseService;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class PSDEViewBaseRTService
extends PSModelRTServiceBase<PSDEViewBase, PSDEViewBaseFilter>
implements IPSDEViewBaseService {
    private static final Log log = LogFactory.getLog(PSDEViewBaseRTService.class);

    public PSDEViewBase createDomain() {
        return new PSDEViewBase();
    }

    public PSDEViewBaseFilter createFilter() {
        return new PSDEViewBaseFilter();
    }

    public PSDEViewBase getDomain(Object params) {
        if (params instanceof PSDEViewBase) {
            return (PSDEViewBase)params;
        }
        return (PSDEViewBase)PSDEViewBaseRTService.getMapper().convertValue(params, PSDEViewBase.class);
    }

    public PSDEViewBaseFilter getFilter(Object params) {
        if (params instanceof PSDEViewBaseFilter) {
            return (PSDEViewBaseFilter)params;
        }
        return (PSDEViewBaseFilter)PSDEViewBaseRTService.getMapper().convertValue(params, PSDEViewBaseFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDEVIEWBASE";
        }
        return "PSDEVIEWBASES";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSAppView.class;
    }

    @Override
    protected List<IPSAppView> getPSModelObjectList(PSDEViewBaseFilter f) throws Exception {
        Object objPSDEId = f.getFieldCond("psdeid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            objPSDEId = PSDEViewBaseRTService.getParentId((IPSModelFilter)f, "PSDATAENTITY");
        }
        String strPSDEId = null;
        if (objPSDEId != null) {
            strPSDEId = (String)objPSDEId;
        }
        ArrayList<IPSAppView> psDEViewBaseList = new ArrayList<IPSAppView>();
        if (!ObjectUtils.isEmpty((Object)this.getPSSystemService().getPSSystem().getAllPSApps())) {
            for (IPSApplication iPSApplication : this.getPSSystemService().getPSSystem().getAllPSApps()) {
                if (ObjectUtils.isEmpty((Object)iPSApplication.getAllPSAppViews())) continue;
                psDEViewBaseList.addAll(iPSApplication.getAllPSAppViews());
            }
        }
        HashMap<String, IPSAppView> psDEViewBaseMap = new HashMap<String, IPSAppView>();
        for (IPSAppView iPSDEViewBase : psDEViewBaseList) {
            String strId;
            if (!(iPSDEViewBase instanceof IPSAppDEView) || StringUtils.hasLength((String)strPSDEId) && (iPSDEViewBase.getPSAppDataEntity() == null || iPSDEViewBase.getPSAppDataEntity().getPSDataEntity() == null || !strPSDEId.equals(strId = this.getPSModelRTServiceSession().getPSModelUniqueTag((IPSModelObject)iPSDEViewBase.getPSAppDataEntity().getPSDataEntity())))) continue;
            IPSAppDEView iPSAppDEView = (IPSAppDEView)iPSDEViewBase;
            String strTag = String.format("%1$s.%2$s", PSModelUtils.calcFullUniqueTag((IPSModelObject)iPSDEViewBase.getPSAppDataEntity().getPSDataEntity(), (boolean)true), iPSAppDEView.getPSDEViewCodeName()).toLowerCase();
            psDEViewBaseMap.put(strTag, iPSDEViewBase);
        }
        psDEViewBaseList.clear();
        psDEViewBaseList.addAll(psDEViewBaseMap.values());
        return psDEViewBaseList;
    }

    @Override
    protected PSDEViewBase doGet(String key, boolean tryMode) throws Exception {
        IPSModelObject iPSModelObject = this.getPSModelObject(key, tryMode);
        if (iPSModelObject != null) {
            PSAppView psAppDEView = (PSAppView)this.getPSModelRTServiceSession().getPSModelListTranspiler(this.getPSModelObjectCls(), false).decompile((IPSModelTranspileContext)this.getPSModelRTServiceSession(), iPSModelObject, null, true);
            PSDEViewBase psDEViewBase = new PSDEViewBase();
            psDEViewBase.putAll(psAppDEView.any());
            IPSAppDEView iPSAppDEView = (IPSAppDEView)iPSModelObject;
            String strTag = String.format("%1$s.%2$s", PSModelUtils.calcFullUniqueTag((IPSModelObject)iPSAppDEView.getPSAppDataEntity().getPSDataEntity(), (boolean)true), iPSAppDEView.getPSDEViewCodeName()).toLowerCase();
            psDEViewBase.setId(strTag);
            this.fillDomain(psDEViewBase, iPSModelObject, true);
            return psDEViewBase;
        }
        return null;
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        String strPSDEId = PSDEViewBaseRTService.getParentId(key);
        PSDEViewBaseFilter psDEViewBaseFilter = new PSDEViewBaseFilter();
        psDEViewBaseFilter.psdeid__eq(strPSDEId);
        List<IPSAppView> psAppViewList = this.getPSModelObjectList(psDEViewBaseFilter);
        if (psAppViewList != null) {
            for (IPSAppView iPSDEViewBase : psAppViewList) {
                String strId;
                if (!(iPSDEViewBase instanceof IPSAppDEView) || StringUtils.hasLength((String)strPSDEId) && (iPSDEViewBase.getPSAppDataEntity() == null || iPSDEViewBase.getPSAppDataEntity().getPSDataEntity() == null || !strPSDEId.equals(strId = this.getPSModelRTServiceSession().getPSModelUniqueTag((IPSModelObject)iPSDEViewBase.getPSAppDataEntity().getPSDataEntity())))) continue;
                IPSAppDEView iPSAppDEView = (IPSAppDEView)iPSDEViewBase;
                String strTag = String.format("%1$s.%2$s", PSModelUtils.calcFullUniqueTag((IPSModelObject)iPSDEViewBase.getPSAppDataEntity().getPSDataEntity(), (boolean)true), iPSAppDEView.getPSDEViewCodeName()).toLowerCase();
                if (!strTag.equalsIgnoreCase(key)) continue;
                return iPSAppDEView;
            }
        }
        if (tryMode) {
            return null;
        }
        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u6a21\u578b\u5bf9\u8c61[%1$s]", key));
    }

    @Override
    protected List<PSDEViewBase> fillDomainList(List<PSDEViewBase> domainList, List<? extends IPSModelObject> psModelObjectList, String strDataSetName, PSDEViewBaseFilter f) throws Exception {
        ArrayList psAppDEViewList = new ArrayList();
        this.getPSModelRTServiceSession().getPSModelListTranspiler(this.getPSModelObjectCls(), false).decompile((IPSModelTranspileContext)this.getPSModelRTServiceSession(), psModelObjectList, psAppDEViewList, false);
        for (int i = 0; i < psAppDEViewList.size(); ++i) {
            PSDEViewBase psDEViewBase = new PSDEViewBase();
            psDEViewBase.putAll(((PSAppDEView)psAppDEViewList.get(i)).any());
            IPSAppDEView iPSAppDEView = (IPSAppDEView)psModelObjectList.get(i);
            String strTag = String.format("%1$s.%2$s", PSModelUtils.calcFullUniqueTag((IPSModelObject)iPSAppDEView.getPSAppDataEntity().getPSDataEntity(), (boolean)true), iPSAppDEView.getPSDEViewCodeName()).toLowerCase();
            psDEViewBase.setId(strTag);
            this.fillDomain(psDEViewBase, (IPSModelObject)iPSAppDEView, false);
            domainList.add(psDEViewBase);
        }
        return domainList;
    }

    @Override
    protected void doFillDomain(PSDEViewBase domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        PSDataEntity parentPSModel = (PSDataEntity)this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", PSDEViewBaseRTService.getParentId(domain.getId()));
        IPSAppDEView iPSAppDEView = (IPSAppDEView)iPSModelObject;
        domain.setPSDEId(parentPSModel.getId());
        domain.setPSDEName(parentPSModel.getName());
        domain.setPSDEViewBaseName(iPSAppDEView.getTitle());
        domain.set("psdeviewbasetype", domain.get("psdeviewtype"));
        super.doFillDomain(domain, iPSModelObject, bFullMode);
        if (bFullMode && iPSAppDEView.getPSControls() != null) {
            int nOrderValue = 100;
            for (IPSControl iPSControl : iPSAppDEView.getPSControls()) {
                PSDEViewCtrl psDEViewCtrl = this.getPSDEViewCtrl(iPSControl);
                if (psDEViewCtrl == null) continue;
                psDEViewCtrl.setPSDEViewBaseId(domain.getPSDEViewBaseId());
                psDEViewCtrl.setPSDEViewBaseName(domain.getPSDEViewBaseName());
                psDEViewCtrl.setPSDEViewCtrlId(String.format("%1$s.%2$s", domain.getPSDEViewBaseId(), psDEViewCtrl.getPSDEViewCtrlName()).toLowerCase());
                psDEViewCtrl.setOrderValue(Integer.valueOf(nOrderValue));
                psDEViewCtrl.setValidFlag(Integer.valueOf(1));
                domain.getPSDEViewCtrlsIf().add(psDEViewCtrl);
                nOrderValue += 100;
            }
        }
    }

    protected PSDEViewCtrl getPSDEViewCtrl(IPSControl iPSControl) throws Exception {
        PSDEViewCtrl psDEViewCtrl = new PSDEViewCtrl();
        String strControlType = iPSControl.getControlType();
        psDEViewCtrl.setPSDEViewCtrlType(strControlType);
        psDEViewCtrl.setPSDEViewCtrlName(iPSControl.getName().toUpperCase());
        if (iPSControl.getPSAppDataEntity() != null && iPSControl.getPSAppDataEntity().getPSDataEntity() != null) {
            psDEViewCtrl.setPSDEId(this.getPSModelRTServiceSession().getPSModelUniqueTag((IPSModelObject)iPSControl.getPSAppDataEntity().getPSDataEntity()));
            psDEViewCtrl.setPSDEName(iPSControl.getPSAppDataEntity().getPSDataEntity().getName());
        }
        switch (strControlType) {
            case "APPMENU": {
                return null;
            }
            case "CALENDAR": {
                IPSSysCalendar iPSSysCalendar = (IPSSysCalendar)iPSControl;
                psDEViewCtrl.setPSSysCalendarId(this.getPSModelRTServiceSession().getPSModelUniqueTag((IPSModelObject)iPSSysCalendar));
                psDEViewCtrl.setPSSysCalendarName(iPSSysCalendar.getLogicName());
                psDEViewCtrl.set("psctrlid", (Object)psDEViewCtrl.getPSSysCalendarId());
                psDEViewCtrl.set("psctrlname", (Object)psDEViewCtrl.getPSSysCalendarName());
                break;
            }
            case "CALENDAREXPBAR": {
                break;
            }
            case "CAPTIONBAR": {
                break;
            }
            case "CHART": {
                break;
            }
            case "CHARTEXPBAR": {
                break;
            }
            case "CONTEXTMENU": {
                break;
            }
            case "CUSTOM": {
                break;
            }
            case "DASHBOARD": {
                break;
            }
            case "DATAINFOBAR": {
                break;
            }
            case "DATAVIEW": {
                break;
            }
            case "DATAVIEWEXPBAR": {
                break;
            }
            case "DRBAR": {
                break;
            }
            case "DRTAB": {
                break;
            }
            case "EXPBAR": {
                break;
            }
            case "FORM": {
                IPSDEForm iPSDEForm = (IPSDEForm)iPSControl;
                psDEViewCtrl.setPSDEFormId(this.getPSModelRTServiceSession().getPSModelUniqueTag((IPSModelObject)iPSDEForm));
                psDEViewCtrl.setPSDEFormName(iPSDEForm.getLogicName());
                psDEViewCtrl.set("psctrlid", (Object)psDEViewCtrl.getPSDEFormId());
                psDEViewCtrl.set("psctrlname", (Object)psDEViewCtrl.getPSDEFormName());
                break;
            }
            case "GANTT": {
                break;
            }
            case "GANTTEXPBAR": {
                break;
            }
            case "GRID": {
                IPSDEGrid iPSDEGrid = (IPSDEGrid)iPSControl;
                psDEViewCtrl.setPSDEGridId(this.getPSModelRTServiceSession().getPSModelUniqueTag((IPSModelObject)iPSDEGrid));
                psDEViewCtrl.setPSDEGridName(iPSDEGrid.getLogicName());
                psDEViewCtrl.set("psctrlid", (Object)psDEViewCtrl.getPSDEGridId());
                psDEViewCtrl.set("psctrlname", (Object)psDEViewCtrl.getPSDEGridName());
                break;
            }
            case "GRIDEXPBAR": {
                break;
            }
            case "KANBAN": {
                break;
            }
            case "LIST": {
                break;
            }
            case "LISTEXPBAR": {
                break;
            }
            case "MAP": {
                break;
            }
            case "MAPEXPBAR": {
                break;
            }
            case "MOBMDCTRL": {
                break;
            }
            case "MULTIEDITVIEWPANEL": {
                break;
            }
            case "PANEL": {
                break;
            }
            case "PICKUPVIEWPANEL": {
                break;
            }
            case "PORTLET": {
                break;
            }
            case "REPORTPANEL": {
                break;
            }
            case "SEARCHBAR": {
                break;
            }
            case "SEARCHFORM": {
                IPSDESearchForm iPSDESearchForm = (IPSDESearchForm)iPSControl;
                psDEViewCtrl.setPSDEFormId(this.getPSModelRTServiceSession().getPSModelUniqueTag((IPSModelObject)iPSDESearchForm));
                psDEViewCtrl.setPSDEFormName(iPSDESearchForm.getLogicName());
                psDEViewCtrl.set("psctrlid", (Object)psDEViewCtrl.getPSDEFormId());
                psDEViewCtrl.set("psctrlname", (Object)psDEViewCtrl.getPSDEFormName());
                break;
            }
            case "STATEWIZARDPANEL": {
                break;
            }
            case "TABEXPPANEL": {
                break;
            }
            case "TABVIEWPANEL": {
                break;
            }
            case "TOOLBAR": {
                IPSDEToolbar iPSDEToolbar = (IPSDEToolbar)iPSControl;
                psDEViewCtrl.setPSDEToolbarId(this.getPSModelRTServiceSession().getPSModelUniqueTag((IPSModelObject)iPSDEToolbar));
                psDEViewCtrl.setPSDEToolbarName(iPSDEToolbar.getLogicName());
                psDEViewCtrl.set("psctrlid", (Object)psDEViewCtrl.getPSDEToolbarId());
                psDEViewCtrl.set("psctrlname", (Object)psDEViewCtrl.getPSDEToolbarName());
                break;
            }
            case "TREEEXPBAR": {
                break;
            }
            case "TREEGRID": {
                break;
            }
            case "TREEGRIDEX": {
                break;
            }
            case "TREEVIEW": {
                break;
            }
            case "VIEWLAYOUTPANEL": {
                break;
            }
            case "VIEWPANEL": {
                break;
            }
            case "WFEXPBAR": {
                break;
            }
        }
        return psDEViewCtrl;
    }
}

