/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.control.IPSControl;
import net.ibizsys.model.control.tree.IPSDETree;
import net.ibizsys.psmodel.core.domain.PSDETreeView;
import net.ibizsys.psmodel.core.domain.PSDataEntity;
import net.ibizsys.psmodel.core.filter.PSDETreeViewFilter;
import net.ibizsys.psmodel.core.service.IPSDETreeViewService;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class PSDETreeViewRTService
extends PSModelRTServiceBase<PSDETreeView, PSDETreeViewFilter>
implements IPSDETreeViewService {
    private static final Log log = LogFactory.getLog(PSDETreeViewRTService.class);

    public PSDETreeView createDomain() {
        return new PSDETreeView();
    }

    public PSDETreeViewFilter createFilter() {
        return new PSDETreeViewFilter();
    }

    public PSDETreeView getDomain(Object params) {
        if (params instanceof PSDETreeView) {
            return (PSDETreeView)params;
        }
        return (PSDETreeView)PSDETreeViewRTService.getMapper().convertValue(params, PSDETreeView.class);
    }

    public PSDETreeViewFilter getFilter(Object params) {
        if (params instanceof PSDETreeViewFilter) {
            return (PSDETreeViewFilter)params;
        }
        return (PSDETreeViewFilter)PSDETreeViewRTService.getMapper().convertValue(params, PSDETreeViewFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDETREEVIEW";
        }
        return "PSDETREEVIEWS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSControl.class;
    }

    @Override
    protected List<IPSDETree> getPSModelObjectList(PSDETreeViewFilter f) throws Exception {
        Object objPSDEId = f.getFieldCond("psdeid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            objPSDEId = PSDETreeViewRTService.getParentId((IPSModelFilter)f, "PSDATAENTITY");
        }
        String strPSDEId = null;
        if (objPSDEId != null) {
            strPSDEId = (String)objPSDEId;
        }
        ArrayList<IPSDETree> psDETreeViewList = new ArrayList<IPSDETree>();
        this.fillPSControlList(IPSDETree.class, psDETreeViewList);
        HashMap<String, IPSDETree> psDETreeViewMap = new HashMap<String, IPSDETree>();
        for (IPSDETree iPSDETreeView : psDETreeViewList) {
            String strId;
            if (StringUtils.hasLength((String)strPSDEId) && (iPSDETreeView.getPSAppDataEntity() == null || iPSDETreeView.getPSAppDataEntity().getPSDataEntity() == null || !strPSDEId.equals(strId = this.getPSModelRTServiceSession().getPSModelUniqueTag((IPSModelObject)iPSDETreeView.getPSAppDataEntity().getPSDataEntity())))) continue;
            psDETreeViewMap.put(this.getPSModelRTServiceSession().getPSModelUniqueTag((IPSModelObject)iPSDETreeView), iPSDETreeView);
        }
        psDETreeViewList.clear();
        psDETreeViewList.addAll(psDETreeViewMap.values());
        return psDETreeViewList;
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSDETree.class, this.getPSModelObjectList(new PSDETreeViewFilter()), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDETreeView domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        PSDataEntity parentPSModel = (PSDataEntity)this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", PSDETreeViewRTService.getParentId(domain.getId()));
        domain.setPSDEId(parentPSModel.getId());
        domain.setPSDEName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

