/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.service.IPSDEServiceAPI;
import net.ibizsys.model.dataentity.service.IPSDEServiceAPIMethod;
import net.ibizsys.model.service.IPSSysServiceAPI;
import net.ibizsys.psmodel.core.domain.PSDESADetail;
import net.ibizsys.psmodel.core.domain.PSDEServiceAPI;
import net.ibizsys.psmodel.core.filter.PSDESADetailFilter;
import net.ibizsys.psmodel.core.service.IPSDESADetailService;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSDESADetailRTService
extends PSModelRTServiceBase<PSDESADetail, PSDESADetailFilter>
implements IPSDESADetailService {
    private static final Log log = LogFactory.getLog(PSDESADetailRTService.class);

    public PSDESADetail createDomain() {
        return new PSDESADetail();
    }

    public PSDESADetailFilter createFilter() {
        return new PSDESADetailFilter();
    }

    public PSDESADetail getDomain(Object params) {
        if (params instanceof PSDESADetail) {
            return (PSDESADetail)params;
        }
        return (PSDESADetail)PSDESADetailRTService.getMapper().convertValue(params, PSDESADetail.class);
    }

    public PSDESADetailFilter getFilter(Object params) {
        if (params instanceof PSDESADetailFilter) {
            return (PSDESADetailFilter)params;
        }
        return (PSDESADetailFilter)PSDESADetailRTService.getMapper().convertValue(params, PSDESADetailFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDESADETAIL";
        }
        return "PSDESADETAILS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSDEServiceAPIMethod.class;
    }

    @Override
    protected List<? extends IPSDEServiceAPIMethod> getPSModelObjectList(PSDESADetailFilter f) throws Exception {
        Object objPSSysServiceAPIId;
        Object objPSDEServiceAPIId = f.getFieldCond("psdeserviceapiid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEServiceAPIId)) {
            objPSDEServiceAPIId = PSDESADetailRTService.getParentId((IPSModelFilter)f, "PSDESERVICEAPI");
        }
        if (ObjectUtils.isEmpty(objPSSysServiceAPIId = null) && ObjectUtils.isEmpty((Object)(objPSSysServiceAPIId = f.getFieldCond("pssysserviceapiid", "EQ")))) {
            objPSSysServiceAPIId = PSDESADetailRTService.getParentId((IPSModelFilter)f, "PSSYSSERVICEAPI");
        }
        if (ObjectUtils.isEmpty((Object)objPSDEServiceAPIId)) {
            if (this.getPSSystemService().getPSSystem().getAllPSSysServiceAPIs() == null) {
                return null;
            }
            ArrayList allPSDESADetailList = new ArrayList();
            for (IPSSysServiceAPI iPSSysServiceAPI : this.getPSSystemService().getPSSystem().getAllPSSysServiceAPIs()) {
                if (!ObjectUtils.isEmpty((Object)objPSSysServiceAPIId) && !this.getPSModelRTServiceSession().getPSModelUniqueTag((IPSModelObject)iPSSysServiceAPI).equals(objPSSysServiceAPIId) || ObjectUtils.isEmpty((Object)iPSSysServiceAPI.getPSDEServiceAPIs())) continue;
                for (IPSDEServiceAPI iPSDEServiceAPI : iPSSysServiceAPI.getPSDEServiceAPIs()) {
                    if (ObjectUtils.isEmpty((Object)iPSDEServiceAPI.getPSDEServiceAPIMethods())) continue;
                    allPSDESADetailList.addAll(iPSDEServiceAPI.getPSDEServiceAPIMethods());
                }
            }
            return allPSDESADetailList;
        }
        return this.getPSModelObject(IPSDEServiceAPI.class, this.getPSModelObject(IPSSysServiceAPI.class, this.getPSSystemService().getPSSystem().getAllPSSysServiceAPIs(), PSDESADetailRTService.getParentId((String)objPSDEServiceAPIId), false).getPSDEServiceAPIs(), (String)objPSDEServiceAPIId, false).getPSDEServiceAPIMethods();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        String strPSDEServiceAPIId = PSDESADetailRTService.getParentId(key);
        return this.getPSModelObject(IPSDEServiceAPIMethod.class, this.getPSModelObject(IPSDEServiceAPI.class, this.getPSModelObject(IPSSysServiceAPI.class, this.getPSSystemService().getPSSystem().getAllPSSysServiceAPIs(), PSDESADetailRTService.getParentId(strPSDEServiceAPIId), false).getPSDEServiceAPIs(), strPSDEServiceAPIId, false).getPSDEServiceAPIMethods(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDESADetail domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        PSDEServiceAPI parentPSModel = (PSDEServiceAPI)this.getPSModelRTServiceSession().getCachePSModel("PSDESERVICEAPI", PSDESADetailRTService.getParentId(domain.getId()));
        domain.setPSDEServiceAPIId(parentPSModel.getId());
        domain.setPSDEServiceAPIName(parentPSModel.getName());
        domain.setPSSysServiceAPIId(parentPSModel.getPSSysServiceAPIId());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

