/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.priv.IPSDEOPPriv;
import net.ibizsys.model.dataentity.priv.IPSSysDEOPPriv;
import net.ibizsys.psmodel.core.domain.PSDEOPPriv;
import net.ibizsys.psmodel.core.filter.PSDEOPPrivFilter;
import net.ibizsys.psmodel.core.service.IPSDEOPPrivService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSDEOPPrivRTService
extends PSModelRTServiceBase<PSDEOPPriv, PSDEOPPrivFilter>
implements IPSDEOPPrivService {
    private static final Log log = LogFactory.getLog(PSDEOPPrivRTService.class);

    public PSDEOPPriv createDomain() {
        return new PSDEOPPriv();
    }

    public PSDEOPPrivFilter createFilter() {
        return new PSDEOPPrivFilter();
    }

    public PSDEOPPriv getDomain(Object params) {
        if (params instanceof PSDEOPPriv) {
            return (PSDEOPPriv)params;
        }
        return (PSDEOPPriv)PSDEOPPrivRTService.getMapper().convertValue(params, PSDEOPPriv.class);
    }

    public PSDEOPPrivFilter getFilter(Object params) {
        if (params instanceof PSDEOPPrivFilter) {
            return (PSDEOPPrivFilter)params;
        }
        return (PSDEOPPrivFilter)PSDEOPPrivRTService.getMapper().convertValue(params, PSDEOPPrivFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDEOPPRIV";
        }
        return "PSDEOPPRIVS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSDEOPPriv.class;
    }

    @Override
    protected List<? extends IPSDEOPPriv> getPSModelObjectList(PSDEOPPrivFilter f) throws Exception {
        Object objPSDEId = f.getFieldCond("psdeid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            objPSDEId = PSDEOPPrivRTService.getParentId((IPSModelFilter)f, "PSDATAENTITY");
        }
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            return this.getPSSystemService().getPSSystem().getAllPSDEOPPrivs();
        }
        return this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), (String)objPSDEId, false).getAllPSDEOPPrivs();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        String strParentId = PSDEOPPrivRTService.getParentId(key);
        if (this.getPSModelRTServiceSession().getPSModelService("PSDATAENTITY").get(strParentId, true) != null) {
            return this.getPSModelObject(IPSDEOPPriv.class, this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), strParentId, false).getAllPSDEOPPrivs(), key, tryMode);
        }
        return this.getPSModelObject(IPSSysDEOPPriv.class, this.getPSSystemService().getPSSystem().getAllPSDEOPPrivs(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDEOPPriv domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        if (iPSModelObject instanceof IPSSysDEOPPriv) {
            super.doFillDomain(domain, iPSModelObject, bFullMode);
            return;
        }
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", PSDEOPPrivRTService.getParentId(domain.getId()));
        domain.setPSDEId(parentPSModel.getId());
        domain.setPSDEName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

