/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.notify.IPSDENotify;
import net.ibizsys.psmodel.core.domain.PSDENotify;
import net.ibizsys.psmodel.core.domain.PSDataEntity;
import net.ibizsys.psmodel.core.filter.PSDENotifyFilter;
import net.ibizsys.psmodel.core.service.IPSDENotifyService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class PSDENotifyRTService
extends PSModelRTServiceBase<PSDENotify, PSDENotifyFilter>
implements IPSDENotifyService {
    private static final Log log = LogFactory.getLog(PSDENotifyRTService.class);

    public PSDENotify createDomain() {
        return new PSDENotify();
    }

    public PSDENotifyFilter createFilter() {
        return new PSDENotifyFilter();
    }

    public PSDENotify getDomain(Object params) {
        if (params instanceof PSDENotify) {
            return (PSDENotify)params;
        }
        return (PSDENotify)PSDENotifyRTService.getMapper().convertValue(params, PSDENotify.class);
    }

    public PSDENotifyFilter getFilter(Object params) {
        if (params instanceof PSDENotifyFilter) {
            return (PSDENotifyFilter)params;
        }
        return (PSDENotifyFilter)PSDENotifyRTService.getMapper().convertValue(params, PSDENotifyFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDENOTIFY";
        }
        return "PSDENOTIFIES";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSDENotify.class;
    }

    @Override
    protected List<? extends IPSDENotify> getPSModelObjectList(PSDENotifyFilter f) throws Exception {
        Object objPSDEId = f.getFieldCond("psdeid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            objPSDEId = PSDENotifyRTService.getParentId((IPSModelFilter)f, "PSDATAENTITY");
        }
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            if (this.getPSSystemService().getPSSystem().getAllPSDataEntities() == null) {
                return null;
            }
            ArrayList allPSDENotifyList = new ArrayList();
            for (IPSDataEntity iPSDataEntity : this.getPSSystemService().getPSSystem().getAllPSDataEntities()) {
                if (iPSDataEntity.getAllPSDENotifies() == null) continue;
                allPSDENotifyList.addAll(iPSDataEntity.getAllPSDENotifies());
            }
            return allPSDENotifyList;
        }
        return this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), (String)objPSDEId, false).getAllPSDENotifies();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSDENotify.class, this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), PSDENotifyRTService.getParentId(key), false).getAllPSDENotifies(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDENotify domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", PSDENotifyRTService.getParentId(domain.getId()));
        domain.setPSDEId(parentPSModel.getId());
        domain.setPSDEName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }

    protected void onBeforeCreate(PSDENotify m) throws Exception {
        if (!StringUtils.hasLength((String)m.getPSDEId())) {
            throw new Exception("\u672a\u4f20\u5165\u5b9e\u4f53\u6807\u8bc6");
        }
        PSDataEntity psDataEntity = (PSDataEntity)this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", m.getPSDEId());
        if (!StringUtils.hasLength((String)m.getCodeName())) {
            m.setCodeName(String.format("uxnotify%1$s", this.getRandom().nextInt(9999999)));
        }
        String strPSDENotifyId = String.format("%1$s.%2$s", m.getPSDEId(), m.getCodeName().toLowerCase());
        m.setPSDENotifyId(strPSDENotifyId);
        m.setPSDEName(psDataEntity.getPSDataEntityName());
        super.onBeforeCreate((IPSModel)m);
    }
}

