/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.control.IPSControl;
import net.ibizsys.model.control.grid.IPSDEGrid;
import net.ibizsys.psmodel.core.domain.PSDEGrid;
import net.ibizsys.psmodel.core.domain.PSDataEntity;
import net.ibizsys.psmodel.core.filter.PSDEGridFilter;
import net.ibizsys.psmodel.core.service.IPSDEGridService;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class PSDEGridRTService
extends PSModelRTServiceBase<PSDEGrid, PSDEGridFilter>
implements IPSDEGridService {
    private static final Log log = LogFactory.getLog(PSDEGridRTService.class);

    public PSDEGrid createDomain() {
        return new PSDEGrid();
    }

    public PSDEGridFilter createFilter() {
        return new PSDEGridFilter();
    }

    public PSDEGrid getDomain(Object params) {
        if (params instanceof PSDEGrid) {
            return (PSDEGrid)params;
        }
        return (PSDEGrid)PSDEGridRTService.getMapper().convertValue(params, PSDEGrid.class);
    }

    public PSDEGridFilter getFilter(Object params) {
        if (params instanceof PSDEGridFilter) {
            return (PSDEGridFilter)params;
        }
        return (PSDEGridFilter)PSDEGridRTService.getMapper().convertValue(params, PSDEGridFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDEGRID";
        }
        return "PSDEGRIDS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSControl.class;
    }

    @Override
    protected List<IPSDEGrid> getPSModelObjectList(PSDEGridFilter f) throws Exception {
        Object objPSDEId = f.getFieldCond("psdeid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            objPSDEId = PSDEGridRTService.getParentId((IPSModelFilter)f, "PSDATAENTITY");
        }
        String strPSDEId = null;
        if (objPSDEId != null) {
            strPSDEId = (String)objPSDEId;
        }
        ArrayList<IPSDEGrid> psDEGridList = new ArrayList<IPSDEGrid>();
        this.fillPSControlList(IPSDEGrid.class, psDEGridList);
        HashMap<String, IPSDEGrid> psDEGridMap = new HashMap<String, IPSDEGrid>();
        for (IPSDEGrid iPSDEGrid : psDEGridList) {
            String strId;
            if (StringUtils.hasLength((String)strPSDEId) && (iPSDEGrid.getPSAppDataEntity() == null || iPSDEGrid.getPSAppDataEntity().getPSDataEntity() == null || !strPSDEId.equals(strId = this.getPSModelRTServiceSession().getPSModelUniqueTag((IPSModelObject)iPSDEGrid.getPSAppDataEntity().getPSDataEntity())))) continue;
            psDEGridMap.put(this.getPSModelRTServiceSession().getPSModelUniqueTag((IPSModelObject)iPSDEGrid), iPSDEGrid);
        }
        psDEGridList.clear();
        psDEGridList.addAll(psDEGridMap.values());
        return psDEGridList;
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSDEGrid.class, this.getPSModelObjectList(new PSDEGridFilter()), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDEGrid domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        PSDataEntity parentPSModel = (PSDataEntity)this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", PSDEGridRTService.getParentId(domain.getId()));
        domain.setPSDEId(parentPSModel.getId());
        domain.setPSDEName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

