/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.valuerule.IPSDEFValueRule;
import net.ibizsys.psmodel.core.domain.PSDEFValueRule;
import net.ibizsys.psmodel.core.domain.PSDEField;
import net.ibizsys.psmodel.core.filter.PSDEFValueRuleFilter;
import net.ibizsys.psmodel.core.service.IPSDEFValueRuleService;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSDEFValueRuleRTService
extends PSModelRTServiceBase<PSDEFValueRule, PSDEFValueRuleFilter>
implements IPSDEFValueRuleService {
    private static final Log log = LogFactory.getLog(PSDEFValueRuleRTService.class);

    public PSDEFValueRule createDomain() {
        return new PSDEFValueRule();
    }

    public PSDEFValueRuleFilter createFilter() {
        return new PSDEFValueRuleFilter();
    }

    public PSDEFValueRule getDomain(Object params) {
        if (params instanceof PSDEFValueRule) {
            return (PSDEFValueRule)params;
        }
        return (PSDEFValueRule)PSDEFValueRuleRTService.getMapper().convertValue(params, PSDEFValueRule.class);
    }

    public PSDEFValueRuleFilter getFilter(Object params) {
        if (params instanceof PSDEFValueRuleFilter) {
            return (PSDEFValueRuleFilter)params;
        }
        return (PSDEFValueRuleFilter)PSDEFValueRuleRTService.getMapper().convertValue(params, PSDEFValueRuleFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDEFVALUERULE";
        }
        return "PSDEFVALUERULES";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSDEFValueRule.class;
    }

    @Override
    protected List<? extends IPSDEFValueRule> getPSModelObjectList(PSDEFValueRuleFilter f) throws Exception {
        Object objPSDEFieldId = f.getFieldCond("psdefid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEFieldId)) {
            objPSDEFieldId = PSDEFValueRuleRTService.getParentId((IPSModelFilter)f, "PSDEFIELD");
        }
        if (ObjectUtils.isEmpty((Object)objPSDEFieldId)) {
            if (this.getPSSystemService().getPSSystem().getAllPSDataEntities() == null) {
                return null;
            }
            ArrayList allPSDEFValueRuleList = new ArrayList();
            for (IPSDataEntity iPSDataEntity : this.getPSSystemService().getPSSystem().getAllPSDataEntities()) {
                if (iPSDataEntity.getAllPSDEFields() == null) continue;
                for (IPSDEField iPSDEField : iPSDataEntity.getAllPSDEFields()) {
                    allPSDEFValueRuleList.addAll(iPSDEField.getAllPSDEFValueRules());
                }
            }
            return allPSDEFValueRuleList;
        }
        String strPSDEId = PSDEFValueRuleRTService.getParentId((String)objPSDEFieldId);
        IPSDEField iPSDEField = this.getPSModelObject(IPSDEField.class, this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), strPSDEId, false).getAllPSDEFields(), (String)objPSDEFieldId, false);
        return iPSDEField.getAllPSDEFValueRules();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        String strPSDEFieldId = PSDEFValueRuleRTService.getParentId(key);
        String strPSDEId = PSDEFValueRuleRTService.getParentId(strPSDEFieldId);
        IPSDEField iPSDEField = this.getPSModelObject(IPSDEField.class, this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), strPSDEId, false).getAllPSDEFields(), strPSDEFieldId, false);
        return this.getPSModelObject(IPSDEFValueRule.class, iPSDEField.getAllPSDEFValueRules(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDEFValueRule domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        PSDEField parentPSModel = (PSDEField)this.getPSModelRTServiceSession().getCachePSModel("PSDEFIELD", PSDEFValueRuleRTService.getParentId(domain.getId()));
        domain.setPSDEFId(parentPSModel.getId());
        domain.setPSDEFName(parentPSModel.getName());
        domain.setPSDEId(parentPSModel.getPSDEId());
        domain.setPSDEName(parentPSModel.getPSDEName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

