/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.defield.IPSDEFGroup;
import net.ibizsys.psmodel.core.domain.PSDEFGroup;
import net.ibizsys.psmodel.core.filter.PSDEFGroupFilter;
import net.ibizsys.psmodel.core.service.IPSDEFGroupService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSDEFGroupRTService
extends PSModelRTServiceBase<PSDEFGroup, PSDEFGroupFilter>
implements IPSDEFGroupService {
    private static final Log log = LogFactory.getLog(PSDEFGroupRTService.class);

    public PSDEFGroup createDomain() {
        return new PSDEFGroup();
    }

    public PSDEFGroupFilter createFilter() {
        return new PSDEFGroupFilter();
    }

    public PSDEFGroup getDomain(Object params) {
        if (params instanceof PSDEFGroup) {
            return (PSDEFGroup)params;
        }
        return (PSDEFGroup)PSDEFGroupRTService.getMapper().convertValue(params, PSDEFGroup.class);
    }

    public PSDEFGroupFilter getFilter(Object params) {
        if (params instanceof PSDEFGroupFilter) {
            return (PSDEFGroupFilter)params;
        }
        return (PSDEFGroupFilter)PSDEFGroupRTService.getMapper().convertValue(params, PSDEFGroupFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDEFGROUP";
        }
        return "PSDEFGROUPS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSDEFGroup.class;
    }

    @Override
    protected List<? extends IPSDEFGroup> getPSModelObjectList(PSDEFGroupFilter f) throws Exception {
        Object objPSDEId = f.getFieldCond("psdeid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            objPSDEId = PSDEFGroupRTService.getParentId((IPSModelFilter)f, "PSDATAENTITY");
        }
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            if (this.getPSSystemService().getPSSystem().getAllPSDataEntities() == null) {
                return null;
            }
            ArrayList allPSDEFGroupList = new ArrayList();
            for (IPSDataEntity iPSDataEntity : this.getPSSystemService().getPSSystem().getAllPSDataEntities()) {
                if (iPSDataEntity.getAllPSDEFGroups() == null) continue;
                allPSDEFGroupList.addAll(iPSDataEntity.getAllPSDEFGroups());
            }
            return allPSDEFGroupList;
        }
        return this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), (String)objPSDEId, false).getAllPSDEFGroups();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSDEFGroup.class, this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), PSDEFGroupRTService.getParentId(key), false).getAllPSDEFGroups(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDEFGroup domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", PSDEFGroupRTService.getParentId(domain.getId()));
        domain.setPSDEId(parentPSModel.getId());
        domain.setPSDEName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

