/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.psmodel.core.domain.PSDEDataQuery;
import net.ibizsys.psmodel.core.filter.PSDEDataQueryFilter;
import net.ibizsys.psmodel.core.service.IPSDEDataQueryService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSDEDataQueryRTService
extends PSModelRTServiceBase<PSDEDataQuery, PSDEDataQueryFilter>
implements IPSDEDataQueryService {
    private static final Log log = LogFactory.getLog(PSDEDataQueryRTService.class);

    public PSDEDataQuery createDomain() {
        return new PSDEDataQuery();
    }

    public PSDEDataQueryFilter createFilter() {
        return new PSDEDataQueryFilter();
    }

    public PSDEDataQuery getDomain(Object params) {
        if (params instanceof PSDEDataQuery) {
            return (PSDEDataQuery)params;
        }
        return (PSDEDataQuery)PSDEDataQueryRTService.getMapper().convertValue(params, PSDEDataQuery.class);
    }

    public PSDEDataQueryFilter getFilter(Object params) {
        if (params instanceof PSDEDataQueryFilter) {
            return (PSDEDataQueryFilter)params;
        }
        return (PSDEDataQueryFilter)PSDEDataQueryRTService.getMapper().convertValue(params, PSDEDataQueryFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDEDATAQUERY";
        }
        return "PSDEDATAQUERIES";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSDEDataQuery.class;
    }

    @Override
    protected List<? extends IPSDEDataQuery> getPSModelObjectList(PSDEDataQueryFilter f) throws Exception {
        Object objPSDEId = f.getFieldCond("psdeid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            objPSDEId = PSDEDataQueryRTService.getParentId((IPSModelFilter)f, "PSDATAENTITY");
        }
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            if (this.getPSSystemService().getPSSystem().getAllPSDataEntities() == null) {
                return null;
            }
            ArrayList allPSDEDataQueryList = new ArrayList();
            for (IPSDataEntity iPSDataEntity : this.getPSSystemService().getPSSystem().getAllPSDataEntities()) {
                if (iPSDataEntity.getAllPSDEDataQueries() == null) continue;
                allPSDEDataQueryList.addAll(iPSDataEntity.getAllPSDEDataQueries());
            }
            return allPSDEDataQueryList;
        }
        return this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), (String)objPSDEId, false).getAllPSDEDataQueries();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSDEDataQuery.class, this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), PSDEDataQueryRTService.getParentId(key), false).getAllPSDEDataQueries(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDEDataQuery domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", PSDEDataQueryRTService.getParentId(domain.getId()));
        domain.setPSDEId(parentPSModel.getId());
        domain.setPSDEName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

