/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.dataimport.IPSDEDataImport;
import net.ibizsys.psmodel.core.domain.PSDEDataImp;
import net.ibizsys.psmodel.core.filter.PSDEDataImpFilter;
import net.ibizsys.psmodel.core.service.IPSDEDataImpService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSDEDataImpRTService
extends PSModelRTServiceBase<PSDEDataImp, PSDEDataImpFilter>
implements IPSDEDataImpService {
    private static final Log log = LogFactory.getLog(PSDEDataImpRTService.class);

    public PSDEDataImp createDomain() {
        return new PSDEDataImp();
    }

    public PSDEDataImpFilter createFilter() {
        return new PSDEDataImpFilter();
    }

    public PSDEDataImp getDomain(Object params) {
        if (params instanceof PSDEDataImp) {
            return (PSDEDataImp)params;
        }
        return (PSDEDataImp)PSDEDataImpRTService.getMapper().convertValue(params, PSDEDataImp.class);
    }

    public PSDEDataImpFilter getFilter(Object params) {
        if (params instanceof PSDEDataImpFilter) {
            return (PSDEDataImpFilter)params;
        }
        return (PSDEDataImpFilter)PSDEDataImpRTService.getMapper().convertValue(params, PSDEDataImpFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDEDATAIMP";
        }
        return "PSDEDATAIMPS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSDEDataImport.class;
    }

    @Override
    protected List<? extends IPSDEDataImport> getPSModelObjectList(PSDEDataImpFilter f) throws Exception {
        Object objPSDEId = f.getFieldCond("psdeid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            objPSDEId = PSDEDataImpRTService.getParentId((IPSModelFilter)f, "PSDATAENTITY");
        }
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            if (this.getPSSystemService().getPSSystem().getAllPSDataEntities() == null) {
                return null;
            }
            ArrayList allPSDEDataImportList = new ArrayList();
            for (IPSDataEntity iPSDataEntity : this.getPSSystemService().getPSSystem().getAllPSDataEntities()) {
                if (iPSDataEntity.getAllPSDEDataImports() == null) continue;
                allPSDEDataImportList.addAll(iPSDataEntity.getAllPSDEDataImports());
            }
            return allPSDEDataImportList;
        }
        return this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), (String)objPSDEId, false).getAllPSDEDataImports();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSDEDataImport.class, this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), PSDEDataImpRTService.getParentId(key), false).getAllPSDEDataImports(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDEDataImp domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", PSDEDataImpRTService.getParentId(domain.getId()));
        domain.setPSDEId(parentPSModel.getId());
        domain.setPSDEName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

