/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.dataflow.IPSDEDataFlow;
import net.ibizsys.psmodel.core.domain.PSDELogic;
import net.ibizsys.psmodel.core.filter.PSDELogicFilter;
import net.ibizsys.psmodel.core.service.IPSDELogicService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.core.util.PSModelEnums;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSDEDataFlowRTService
extends PSModelRTServiceBase<PSDELogic, PSDELogicFilter>
implements IPSDELogicService {
    private static final Log log = LogFactory.getLog(PSDEDataFlowRTService.class);

    public PSDELogic createDomain() {
        return new PSDELogic();
    }

    public PSDELogicFilter createFilter() {
        return new PSDELogicFilter();
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDEDATAFLOW";
        }
        return "PSDEDATAFLOWS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSDEDataFlow.class;
    }

    @Override
    protected List<? extends IPSDEDataFlow> getPSModelObjectList(PSDELogicFilter f) throws Exception {
        Object objPSDEId = f.getFieldCond("psdeid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            objPSDEId = PSDEDataFlowRTService.getParentId((IPSModelFilter)f, "PSDATAENTITY");
        }
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            if (this.getPSSystemService().getPSSystem().getAllPSDataEntities() == null) {
                return null;
            }
            ArrayList allPSDEDataFlowList = new ArrayList();
            for (IPSDataEntity iPSDataEntity : this.getPSSystemService().getPSSystem().getAllPSDataEntities()) {
                if (iPSDataEntity.getAllPSDEDataFlows() == null) continue;
                allPSDEDataFlowList.addAll(iPSDataEntity.getAllPSDEDataFlows());
            }
            return allPSDEDataFlowList;
        }
        return this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), (String)objPSDEId, false).getAllPSDEDataFlows();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSDEDataFlow.class, this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), PSDEDataFlowRTService.getParentId(key), false).getAllPSDEDataFlows(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDELogic domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", PSDEDataFlowRTService.getParentId(domain.getId()));
        domain.setPSDEId(parentPSModel.getId());
        domain.setPSDEName(parentPSModel.getName());
        domain.logictype(PSModelEnums.LogicType.DATAFLOWLOGIC);
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

