/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.database.IPSDEDBTable;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.psmodel.core.domain.PSDEDBTable;
import net.ibizsys.psmodel.core.filter.PSDEDBTableFilter;
import net.ibizsys.psmodel.core.service.IPSDEDBTableService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSDEDBTableRTService
extends PSModelRTServiceBase<PSDEDBTable, PSDEDBTableFilter>
implements IPSDEDBTableService {
    private static final Log log = LogFactory.getLog(PSDEDBTableRTService.class);

    public PSDEDBTable createDomain() {
        return new PSDEDBTable();
    }

    public PSDEDBTableFilter createFilter() {
        return new PSDEDBTableFilter();
    }

    public PSDEDBTable getDomain(Object params) {
        if (params instanceof PSDEDBTable) {
            return (PSDEDBTable)params;
        }
        return (PSDEDBTable)PSDEDBTableRTService.getMapper().convertValue(params, PSDEDBTable.class);
    }

    public PSDEDBTableFilter getFilter(Object params) {
        if (params instanceof PSDEDBTableFilter) {
            return (PSDEDBTableFilter)params;
        }
        return (PSDEDBTableFilter)PSDEDBTableRTService.getMapper().convertValue(params, PSDEDBTableFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDEDBTABLE";
        }
        return "PSDEDBTABLES";
    }

    @Override
    protected String getOriginModelName() {
        return "PSDETABLE";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSDEDBTable.class;
    }

    @Override
    protected List<? extends IPSDEDBTable> getPSModelObjectList(PSDEDBTableFilter f) throws Exception {
        Object objPSSysDBTableId;
        Object objPSDEId = f.getFieldCond("psdeid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            objPSDEId = PSDEDBTableRTService.getParentId((IPSModelFilter)f, "PSDATAENTITY");
        }
        if (ObjectUtils.isEmpty((Object)(objPSSysDBTableId = f.getFieldCond("pssysdbtableid", "EQ"))) && !ObjectUtils.isEmpty((Object)(objPSSysDBTableId = PSDEDBTableRTService.getParentId((IPSModelFilter)f, "PSSYSDBTABLE")))) {
            f.setFieldCond("pssysdbtableid", "EQ", objPSSysDBTableId);
        }
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            if (this.getPSSystemService().getPSSystem().getAllPSDataEntities() == null) {
                return null;
            }
            ArrayList allPSDEDBTableList = new ArrayList();
            for (IPSDataEntity iPSDataEntity : this.getPSSystemService().getPSSystem().getAllPSDataEntities()) {
                if (iPSDataEntity.getAllPSDEDBTables() == null) continue;
                allPSDEDBTableList.addAll(iPSDataEntity.getAllPSDEDBTables());
            }
            return allPSDEDBTableList;
        }
        return this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), (String)objPSDEId, false).getAllPSDEDBTables();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSDEDBTable.class, this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), PSDEDBTableRTService.getParentId(key), false).getAllPSDEDBTables(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDEDBTable domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", PSDEDBTableRTService.getParentId(domain.getId()));
        domain.setPSDEId(parentPSModel.getId());
        domain.setPSDEName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

