/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.model.app.dataentity.IPSAppDEACMode;
import net.ibizsys.model.app.dataentity.IPSAppDataEntity;
import net.ibizsys.model.dataentity.ac.IPSDEACMode;
import net.ibizsys.psmodel.core.domain.PSDEACMode;
import net.ibizsys.psmodel.core.domain.PSDataEntity;
import net.ibizsys.psmodel.core.filter.PSDEACModeFilter;
import net.ibizsys.psmodel.core.service.IPSDEACModeService;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSDEACModeRTService
extends PSModelRTServiceBase<PSDEACMode, PSDEACModeFilter>
implements IPSDEACModeService {
    private static final Log log = LogFactory.getLog(PSDEACModeRTService.class);

    public PSDEACMode createDomain() {
        return new PSDEACMode();
    }

    public PSDEACModeFilter createFilter() {
        return new PSDEACModeFilter();
    }

    public PSDEACMode getDomain(Object params) {
        if (params instanceof PSDEACMode) {
            return (PSDEACMode)params;
        }
        return (PSDEACMode)PSDEACModeRTService.getMapper().convertValue(params, PSDEACMode.class);
    }

    public PSDEACModeFilter getFilter(Object params) {
        if (params instanceof PSDEACModeFilter) {
            return (PSDEACModeFilter)params;
        }
        return (PSDEACModeFilter)PSDEACModeRTService.getMapper().convertValue(params, PSDEACModeFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDEACMODE";
        }
        return "PSDEACMODES";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSDEACMode.class;
    }

    @Override
    protected List<IPSDEACMode> getPSModelObjectList(PSDEACModeFilter f) throws Exception {
        Object objPSDEId = f.getFieldCond("psdeid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            objPSDEId = PSDEACModeRTService.getParentId((IPSModelFilter)f, "PSDATAENTITY");
        }
        String strPSDEId = null;
        if (objPSDEId != null) {
            strPSDEId = (String)objPSDEId;
        }
        HashMap<String, IPSAppDEACMode> psDEACModeMap = new HashMap<String, IPSAppDEACMode>();
        ArrayList<IPSDEACMode> psAppDEACModeList = new ArrayList<IPSDEACMode>();
        if (!ObjectUtils.isEmpty((Object)this.getPSSystemService().getPSSystem().getAllPSApps())) {
            for (IPSApplication iPSApplication : this.getPSSystemService().getPSSystem().getAllPSApps()) {
                if (ObjectUtils.isEmpty((Object)iPSApplication.getAllPSAppDataEntities())) continue;
                for (IPSAppDataEntity iPSAppDataEntity : iPSApplication.getAllPSAppDataEntities()) {
                    if (iPSAppDataEntity.getPSDataEntity() == null) continue;
                    String strId = this.getPSModelRTServiceSession().getPSModelUniqueTag((IPSModelObject)iPSAppDataEntity.getPSDataEntity());
                    if (strPSDEId != null && !strPSDEId.equals(strId) || ObjectUtils.isEmpty((Object)iPSAppDataEntity.getAllPSAppDEACModes())) continue;
                    for (IPSAppDEACMode iPSAppDEACMode : iPSAppDataEntity.getAllPSAppDEACModes()) {
                        psDEACModeMap.put(this.getPSModelRTServiceSession().getPSModelUniqueTag((IPSModelObject)iPSAppDEACMode), iPSAppDEACMode);
                    }
                }
            }
        }
        psAppDEACModeList.clear();
        psAppDEACModeList.addAll(psDEACModeMap.values());
        return psAppDEACModeList;
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSDEACMode.class, this.getPSModelObjectList(new PSDEACModeFilter()), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDEACMode domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        PSDataEntity parentPSModel = (PSDataEntity)this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", PSDEACModeRTService.getParentId(domain.getId()));
        domain.setPSDEId(parentPSModel.getId());
        domain.setPSDEName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

