/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.app.IPSAppResource;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.psmodel.core.domain.PSAppResource;
import net.ibizsys.psmodel.core.filter.PSAppResourceFilter;
import net.ibizsys.psmodel.core.service.IPSAppResourceService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSAppResourceRTService
extends PSModelRTServiceBase<PSAppResource, PSAppResourceFilter>
implements IPSAppResourceService {
    private static final Log log = LogFactory.getLog(PSAppResourceRTService.class);

    public PSAppResource createDomain() {
        return new PSAppResource();
    }

    public PSAppResourceFilter createFilter() {
        return new PSAppResourceFilter();
    }

    public PSAppResource getDomain(Object params) {
        if (params instanceof PSAppResource) {
            return (PSAppResource)params;
        }
        return (PSAppResource)PSAppResourceRTService.getMapper().convertValue(params, PSAppResource.class);
    }

    public PSAppResourceFilter getFilter(Object params) {
        if (params instanceof PSAppResourceFilter) {
            return (PSAppResourceFilter)params;
        }
        return (PSAppResourceFilter)PSAppResourceRTService.getMapper().convertValue(params, PSAppResourceFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSAPPRESOURCE";
        }
        return "PSAPPRESOURCES";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSAppResource.class;
    }

    @Override
    protected List<? extends IPSAppResource> getPSModelObjectList(PSAppResourceFilter f) throws Exception {
        Object objPSSysAppId = f.getFieldCond("pssysappid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSSysAppId) && ObjectUtils.isEmpty((Object)(objPSSysAppId = PSAppResourceRTService.getParentId((IPSModelFilter)f, "PSSYSAPP")))) {
            throw new Exception("\u672a\u6307\u5b9a\u5e94\u7528\u6807\u8bc6");
        }
        return this.getPSModelObject(IPSApplication.class, this.getPSSystemService().getPSSystem().getAllPSApps(), (String)objPSSysAppId, false).getAllPSAppResources();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSAppResource.class, this.getPSModelObject(IPSApplication.class, this.getPSSystemService().getPSSystem().getAllPSApps(), PSAppResourceRTService.getParentId(key), false).getAllPSAppResources(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSAppResource domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSSYSAPP", PSAppResourceRTService.getParentId(domain.getId()));
        domain.setPSSysAppId(parentPSModel.getId());
        domain.setPSSysAppName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

