/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.app.IPSAppPkg;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.psmodel.core.domain.PSAppPkg;
import net.ibizsys.psmodel.core.filter.PSAppPkgFilter;
import net.ibizsys.psmodel.core.service.IPSAppPkgService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSAppPkgRTService
extends PSModelRTServiceBase<PSAppPkg, PSAppPkgFilter>
implements IPSAppPkgService {
    private static final Log log = LogFactory.getLog(PSAppPkgRTService.class);

    public PSAppPkg createDomain() {
        return new PSAppPkg();
    }

    public PSAppPkgFilter createFilter() {
        return new PSAppPkgFilter();
    }

    public PSAppPkg getDomain(Object params) {
        if (params instanceof PSAppPkg) {
            return (PSAppPkg)params;
        }
        return (PSAppPkg)PSAppPkgRTService.getMapper().convertValue(params, PSAppPkg.class);
    }

    public PSAppPkgFilter getFilter(Object params) {
        if (params instanceof PSAppPkgFilter) {
            return (PSAppPkgFilter)params;
        }
        return (PSAppPkgFilter)PSAppPkgRTService.getMapper().convertValue(params, PSAppPkgFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSAPPPKG";
        }
        return "PSAPPPKGS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSAppPkg.class;
    }

    @Override
    protected List<? extends IPSAppPkg> getPSModelObjectList(PSAppPkgFilter f) throws Exception {
        Object objPSSysAppId = f.getFieldCond("pssysappid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSSysAppId) && ObjectUtils.isEmpty((Object)(objPSSysAppId = PSAppPkgRTService.getParentId((IPSModelFilter)f, "PSSYSAPP")))) {
            throw new Exception("\u672a\u6307\u5b9a\u5e94\u7528\u6807\u8bc6");
        }
        return this.getPSModelObject(IPSApplication.class, this.getPSSystemService().getPSSystem().getAllPSApps(), (String)objPSSysAppId, false).getAllPSAppPkgs();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSAppPkg.class, this.getPSModelObject(IPSApplication.class, this.getPSSystemService().getPSSystem().getAllPSApps(), PSAppPkgRTService.getParentId(key), false).getAllPSAppPkgs(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSAppPkg domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSSYSAPP", PSAppPkgRTService.getParentId(domain.getId()));
        domain.setPSSysAppId(parentPSModel.getId());
        domain.setPSSysAppName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

