/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.app.IPSAppModule;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.psmodel.core.domain.PSAppModule;
import net.ibizsys.psmodel.core.filter.PSAppModuleFilter;
import net.ibizsys.psmodel.core.service.IPSAppModuleService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSAppModuleRTService
extends PSModelRTServiceBase<PSAppModule, PSAppModuleFilter>
implements IPSAppModuleService {
    private static final Log log = LogFactory.getLog(PSAppModuleRTService.class);

    public PSAppModule createDomain() {
        return new PSAppModule();
    }

    public PSAppModuleFilter createFilter() {
        return new PSAppModuleFilter();
    }

    public PSAppModule getDomain(Object params) {
        if (params instanceof PSAppModule) {
            return (PSAppModule)params;
        }
        return (PSAppModule)PSAppModuleRTService.getMapper().convertValue(params, PSAppModule.class);
    }

    public PSAppModuleFilter getFilter(Object params) {
        if (params instanceof PSAppModuleFilter) {
            return (PSAppModuleFilter)params;
        }
        return (PSAppModuleFilter)PSAppModuleRTService.getMapper().convertValue(params, PSAppModuleFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSAPPMODULE";
        }
        return "PSAPPMODULES";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSAppModule.class;
    }

    @Override
    protected List<? extends IPSAppModule> getPSModelObjectList(PSAppModuleFilter f) throws Exception {
        Object objPSSysAppId = f.getFieldCond("pssysappid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSSysAppId) && ObjectUtils.isEmpty((Object)(objPSSysAppId = PSAppModuleRTService.getParentId((IPSModelFilter)f, "PSSYSAPP")))) {
            throw new Exception("\u672a\u6307\u5b9a\u5e94\u7528\u6807\u8bc6");
        }
        return this.getPSModelObject(IPSApplication.class, this.getPSSystemService().getPSSystem().getAllPSApps(), (String)objPSSysAppId, false).getAllPSAppModules();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSAppModule.class, this.getPSModelObject(IPSApplication.class, this.getPSSystemService().getPSSystem().getAllPSApps(), PSAppModuleRTService.getParentId(key), false).getAllPSAppModules(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSAppModule domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSSYSAPP", PSAppModuleRTService.getParentId(domain.getId()));
        domain.setPSSysAppId(parentPSModel.getId());
        domain.setPSSysAppName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

