/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.model.app.view.IPSAppView;
import net.ibizsys.psmodel.core.domain.PSAppIndexView;
import net.ibizsys.psmodel.core.filter.PSAppIndexViewFilter;
import net.ibizsys.psmodel.core.service.IPSAppIndexViewService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSAppIndexViewRTService
extends PSModelRTServiceBase<PSAppIndexView, PSAppIndexViewFilter>
implements IPSAppIndexViewService {
    private static final Log log = LogFactory.getLog(PSAppIndexViewRTService.class);

    public PSAppIndexView createDomain() {
        return new PSAppIndexView();
    }

    public PSAppIndexViewFilter createFilter() {
        return new PSAppIndexViewFilter();
    }

    public PSAppIndexView getDomain(Object params) {
        if (params instanceof PSAppIndexView) {
            return (PSAppIndexView)params;
        }
        return (PSAppIndexView)PSAppIndexViewRTService.getMapper().convertValue(params, PSAppIndexView.class);
    }

    public PSAppIndexViewFilter getFilter(Object params) {
        if (params instanceof PSAppIndexViewFilter) {
            return (PSAppIndexViewFilter)params;
        }
        return (PSAppIndexViewFilter)PSAppIndexViewRTService.getMapper().convertValue(params, PSAppIndexViewFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSAPPINDEXVIEW";
        }
        return "PSAPPINDEXVIEWS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSAppView.class;
    }

    @Override
    protected List<? extends IPSAppView> getPSModelObjectList(PSAppIndexViewFilter f) throws Exception {
        Object objPSSysAppId = f.getFieldCond("pssysappid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSSysAppId) && ObjectUtils.isEmpty((Object)(objPSSysAppId = PSAppIndexViewRTService.getParentId((IPSModelFilter)f, "PSSYSAPP")))) {
            throw new Exception("\u672a\u6307\u5b9a\u5e94\u7528\u6807\u8bc6");
        }
        return this.getPSModelObject(IPSApplication.class, this.getPSSystemService().getPSSystem().getAllPSApps(), (String)objPSSysAppId, false).getAllPSAppViews();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSAppView.class, this.getPSModelObject(IPSApplication.class, this.getPSSystemService().getPSSystem().getAllPSApps(), PSAppIndexViewRTService.getParentId(key), false).getAllPSAppViews(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSAppIndexView domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSSYSAPP", PSAppIndexViewRTService.getParentId(domain.getId()));
        domain.setPSSysAppId(parentPSModel.getId());
        domain.setPSSysAppName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

