/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.model.app.dataentity.IPSAppDataEntity;
import net.ibizsys.psmodel.core.domain.PSAppDataEntity;
import net.ibizsys.psmodel.core.filter.PSAppDataEntityFilter;
import net.ibizsys.psmodel.core.service.IPSAppDataEntityService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSAppDataEntityRTService
extends PSModelRTServiceBase<PSAppDataEntity, PSAppDataEntityFilter>
implements IPSAppDataEntityService {
    private static final Log log = LogFactory.getLog(PSAppDataEntityRTService.class);

    public PSAppDataEntity createDomain() {
        return new PSAppDataEntity();
    }

    public PSAppDataEntityFilter createFilter() {
        return new PSAppDataEntityFilter();
    }

    public PSAppDataEntity getDomain(Object params) {
        if (params instanceof PSAppDataEntity) {
            return (PSAppDataEntity)params;
        }
        return (PSAppDataEntity)PSAppDataEntityRTService.getMapper().convertValue(params, PSAppDataEntity.class);
    }

    public PSAppDataEntityFilter getFilter(Object params) {
        if (params instanceof PSAppDataEntityFilter) {
            return (PSAppDataEntityFilter)params;
        }
        return (PSAppDataEntityFilter)PSAppDataEntityRTService.getMapper().convertValue(params, PSAppDataEntityFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSAPPDATAENTITY";
        }
        return "PSAPPDATAENTITIES";
    }

    @Override
    protected String getOriginModelName() {
        return "PSAPPLOCALDE";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSAppDataEntity.class;
    }

    @Override
    protected List<? extends IPSAppDataEntity> getPSModelObjectList(PSAppDataEntityFilter f) throws Exception {
        Object objPSSysAppId = f.getFieldCond("pssysappid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSSysAppId) && ObjectUtils.isEmpty((Object)(objPSSysAppId = PSAppDataEntityRTService.getParentId((IPSModelFilter)f, "PSSYSAPP")))) {
            throw new Exception("\u672a\u6307\u5b9a\u5e94\u7528\u6807\u8bc6");
        }
        return this.getPSModelObject(IPSApplication.class, this.getPSSystemService().getPSSystem().getAllPSApps(), (String)objPSSysAppId, false).getAllPSAppDataEntities();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSAppDataEntity.class, this.getPSModelObject(IPSApplication.class, this.getPSSystemService().getPSSystem().getAllPSApps(), PSAppDataEntityRTService.getParentId(key), false).getAllPSAppDataEntities(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSAppDataEntity domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSSYSAPP", PSAppDataEntityRTService.getParentId(domain.getId()));
        domain.setPSSysAppId(parentPSModel.getId());
        domain.setPSSysAppName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

