package net.ibizsys.central.plugin.querydsl.dataentity.ds;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;

import net.ibizsys.model.PSModelEnums.DEDataQueryViewLevel;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.defield.IPSDEFGroupDetail;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.IPSLinkDEField;
import net.ibizsys.model.dataentity.ds.IPSDEDQCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDQFieldCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDQGroupCondition;
import net.ibizsys.model.dataentity.ds.IPSDEDQJoin;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.runtime.dataentity.defield.DEFPredefinedTypes;
import net.ibizsys.runtime.util.Conditions;
import net.ibizsys.runtime.util.DataTypeUtils;

public abstract class QuerydslDEDataQueryBase {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(QuerydslDEDataQueryBase.class);
	
	private IQuerydslSession iQuerydslSession = null;
	private IPSDEDataQuery iPSDEDataQuery = null;
	private List<IPSDEField> selectPSDEFieldList = null;
	private List<? extends QuerydslDEDataQueryBase> unionQuerydslDEDataQueryList = null;
	private Map<String, Expression<?>> psDEFieldExpressionMap = new LinkedHashMap<>();
	private IQuerydslDataEntity iQuerydslDataEntity = null;
	
		
	public QuerydslDEDataQueryBase(IQuerydslSession iQuerydslSession, IPSDEDataQuery iPSDEDataQuery) throws Exception {
		this(iQuerydslSession, iPSDEDataQuery, null);
	}
	
	public QuerydslDEDataQueryBase(IQuerydslSession iQuerydslSession, IPSDEDataQuery iPSDEDataQuery, List<IPSDEField> selectPSDEFieldList) throws Exception {
		this.iQuerydslSession = iQuerydslSession;
		this.iPSDEDataQuery = iPSDEDataQuery;
		this.selectPSDEFieldList = selectPSDEFieldList;
		this.initMetadata();
	}
	
	public IPSDEDataQuery getPSDEDataQuery() {
		return this.iPSDEDataQuery;
	}
	
	public IPSDataEntity getPSDataEntity() {
		return getPSDEDataQuery().getParentPSModelObject(IPSDataEntity.class, false);
	}
	
	public List<IPSDEField> getSelectPSDEFields() {
		return this.selectPSDEFieldList;
	}
	
	protected void initMetadata() throws Exception{
		onInitMetadata();
	}
	
	protected IQuerydslSession getQuerydslSession() {
		return this.iQuerydslSession;
	}
	
	public IQuerydslDataEntity getQuerydslDataEntity() {
		return this.iQuerydslDataEntity;
	}
	
	protected void onInitMetadata() throws Exception {
		
		this.iQuerydslDataEntity = getQuerydslSession().getQuerydslDataEntity(this.getPSDataEntity(), "");
		
		TreeMap<String, Integer> selectedPSDEFieldMap = new TreeMap<String, Integer>();
		if(!ObjectUtils.isEmpty(this.getSelectPSDEFields())) {
			for(IPSDEField iPSDEField : this.getSelectPSDEFields()) {
				selectedPSDEFieldMap.put(iPSDEField.getName(), 1);
			}
		}
		else {
			if(this.getPSDEDataQuery().getViewLevel() == DEDataQueryViewLevel.DEFGROUP.value
					&& this.getPSDEDataQuery().getPSDEFGroup()!=null) {
				java.util.List<IPSDEFGroupDetail> psDEFGroupDetails = this.getPSDEDataQuery().getPSDEFGroup().getPSDEFGroupDetails();
				if(!ObjectUtils.isEmpty(psDEFGroupDetails)) {
					for(IPSDEFGroupDetail iPSDEFGroupDetail : psDEFGroupDetails) {
						selectedPSDEFieldMap.put(iPSDEFGroupDetail.getPSDEFieldMust().getName(), 1);
					}
				}
			}
		}
		
		boolean bSelectPSDEField = selectedPSDEFieldMap.size() > 0;
		
		java.util.List<IPSDEField> psDEFields = this.getPSDataEntity().getAllPSDEFields();
		if(!ObjectUtils.isEmpty(psDEFields)) {
			for(IPSDEField iPSDEField : psDEFields) {

				if (iPSDEField.isDynaStorageDEField() || iPSDEField.isUIAssistDEField()) {
					continue;
				}
				
				if(!iPSDEField.isPhisicalDEField() && iPSDEField.isLinkDEField()) {
					IPSLinkDEField iPSLinkDEField = (IPSLinkDEField)iPSDEField;
					if(!iPSLinkDEField.getRealPSDataEntityMust().isEnableSQLStorage()) {
						log.warn(String.format("属性[%1$s]实际引用实体[%2$s]不支持SQL存储，忽略", iPSLinkDEField.getName(), iPSLinkDEField.getRealPSDataEntity().getName()));
						continue;
					}
				}
					

				if(bSelectPSDEField && selectedPSDEFieldMap.containsKey(iPSDEField.getName())) {
					//选择列
				}
				else
					if (!this.testSelectPSDEField(iPSDEField, this.getPSDEDataQuery().getViewLevel())|| bSelectPSDEField) {
						if (!iPSDEField.isQueryColumn() || !selectedPSDEFieldMap.containsKey(iPSDEField.getName())) {
							
							if (!iPSDEField.isPhisicalDEField()) {
								if (!iPSDEField.isInheritDEField())
									continue;
							}
	
//							IPSDEFDTColumn iPSDEFDTColumn = iPSDEField.getPSDTColumn(this.getDBType());
//							String strPSDEFieldExp = null;
//							if (mainQueryConfig.getPSDEDataQuery().isQueryFromView()) {
//								strPSDEFieldExp = StringHelper.Format("%1$s.%2$s", "t1", this.iPSDBType.getDBObjStandardName(iPSDEFDTColumn.getColumnName()));
//								this.setFieldQueryCaseSensitive(strPSDEFieldExp, iPSDEFDTColumn.getQueryCaseSenstive());
//							} else {
//								strPSDEFieldExp = getPSDEFieldExp(iPSDEField, "", derAliasMap, derList);
//							}
//	
//	
//	
//							int nDataType = iPSDEField.getStdDataType();
//			
//	
//							fieldDataTypeMap.put(iPSDEFDTColumn.getColumnName().toUpperCase(), nDataType);
//							fieldExpMap.put(iPSDEFDTColumn.getColumnName().toUpperCase(), strPSDEFieldExp);
//							continue;
						}
					}
				
				if (iPSDEField.getStringLength() != -1 && iPSDEField.getStringLength() > 8000){
					log.error(String.format("长文本属性[%1$s]放入查询中，会影响检索性能", iPSDEField.getName()));
				}
				
				Expression<?> expression = this.getQuerydslDataEntity().getExpression(iPSDEField);
				this.psDEFieldExpressionMap.put(iPSDEField.getName(), expression);


			}
		}
		
		this.buildPSDEDQJoin(this.getPSDEDataQuery().getPSDEDQMainMust(), this.getQuerydslDataEntity());
		
	}
	
	protected void buildPSDEDQJoin(IPSDEDQJoin iPSDEDQJoin, IQuerydslDataEntity iQuerydslDataEntity) throws Exception {
		
		//放入条件
		IPSDEDQGroupCondition iPSDEDQGroupCondition = iPSDEDQJoin.getPSDEDQGroupCondition();
		if(iPSDEDQGroupCondition != null) {
			Predicate predicate = this.buildPSDEDQGroupCondition(iPSDEDQGroupCondition, iQuerydslDataEntity);
			if(predicate != null) {
				iQuerydslDataEntity.getPredicates().add(predicate);
			}
		}
		
		
		List<IPSDEDQJoin> childPSDEDQJoinList = iPSDEDQJoin.getChildPSDEDQJoins();
		if(!ObjectUtils.isEmpty(childPSDEDQJoinList)) {
			for(IPSDEDQJoin childPSDEDQJoin : childPSDEDQJoinList) {
				IQuerydslDataEntity joinQuerydslDataEntity = iQuerydslDataEntity.getJoinQuerydslDataEntity(childPSDEDQJoin.getJoinType(), childPSDEDQJoin.getJoinPSDERMust());
				this.buildPSDEDQJoin(childPSDEDQJoin, joinQuerydslDataEntity);
			}
		}
				
		
	}
	
	protected Predicate buildPSDEDQGroupCondition(IPSDEDQGroupCondition iPSDEDQGroupCondition, IQuerydslDataEntity iQuerydslDataEntity) throws Exception{
		
		if(ObjectUtils.isEmpty(iPSDEDQGroupCondition.getPSDEDQConditions())) {
			return null;
		}
		BooleanBuilder booleanBuilder = new BooleanBuilder();
		for(IPSDEDQCondition iPSDEDQCondition : iPSDEDQGroupCondition.getPSDEDQConditions()) {
			if(iPSDEDQCondition instanceof IPSDEDQFieldCondition) {
				Predicate predicate = this.buildPSDEDQFieldCondition((IPSDEDQFieldCondition)iPSDEDQCondition, iQuerydslDataEntity);
				if(predicate != null) {
					if(Conditions.AND.equalsIgnoreCase(iPSDEDQGroupCondition.getCondOp())) {
						booleanBuilder.and(predicate);
					}
					else {
						booleanBuilder.or(predicate);
					}
				}
				continue;
			}
			
			if(iPSDEDQCondition instanceof IPSDEDQGroupCondition) {
				Predicate predicate = this.buildPSDEDQGroupCondition((IPSDEDQGroupCondition)iPSDEDQCondition, iQuerydslDataEntity);
				if(predicate != null) {
					if(Conditions.AND.equalsIgnoreCase(iPSDEDQGroupCondition.getCondOp())) {
						booleanBuilder.and(predicate);
					}
					else {
						booleanBuilder.or(predicate);
					}
				}
				continue;
			}
		}
		
		if(iPSDEDQGroupCondition.isNotMode()) {
			return booleanBuilder.not();
		}
		return booleanBuilder;
	}
	
	protected Predicate buildPSDEDQFieldCondition(IPSDEDQFieldCondition iPSDEDQFieldCondition, IQuerydslDataEntity iQuerydslDataEntity) throws Exception{
		
		IPSDEField iPSDEField = iQuerydslDataEntity.getPSDEField(iPSDEDQFieldCondition.getFieldName(), false);
		Expression<?> expression = iQuerydslDataEntity.getExpression(iPSDEField);
		SimpleExpression simpleExpression = (SimpleExpression)expression;
		
		int nStdDataType = iPSDEField.getStdDataType();
		
		String strCondOp = iPSDEDQFieldCondition.getCondOp();
		if(Conditions.ISNULL.equals(strCondOp)) {
			return simpleExpression.isNull();
		}
		
		if(Conditions.ISNOTNULL.equals(strCondOp)) {
			return simpleExpression.isNotNull();
		}
		
		String strPSVarType = iPSDEDQFieldCondition.getPSVARTypeId();
		if(StringUtils.hasLength(strPSVarType)) {
			throw new Exception(String.format("未支持的变量类型[%1$s]", strPSVarType));
		}
		else {
			String strCondValue = iPSDEDQFieldCondition.getCondValue();
			if(StringUtils.hasLength(strCondValue)) {
				strCondValue = String.format("%1$s", strCondValue.replace("'", "\\'"));
			}
			else {
				strCondValue = "";
			}
			
			if(DataTypeUtils.isStringDataType(nStdDataType)) {
				StringExpression stringExpression = (StringExpression)expression;
			
				if(Conditions.EQ.equals(strCondOp)) {
					return stringExpression.eq(Expressions.stringTemplate(String.format("'%1$s'", strCondValue)));
				}
				
				if(Conditions.NOTEQ.equals(strCondOp)) {
					return stringExpression.ne(Expressions.stringTemplate(String.format("'%1$s'", strCondValue)));
				}
				
				if(Conditions.LIKE.equals(strCondOp)) {
					return stringExpression.like(Expressions.stringTemplate(String.format("'%%%1$s%%'", strCondValue)));
				}
				
				if(Conditions.LEFTLIKE.equals(strCondOp)) {
					return stringExpression.like(Expressions.stringTemplate(String.format("'%1$s%%'", strCondValue)));
				}
				
				if(Conditions.RIGHTLIKE.equals(strCondOp)) {
					return stringExpression.like(Expressions.stringTemplate(String.format("'%%%1$s'", strCondValue)));
				}
				
				throw new Exception(String.format("未支持的条件操作[%1$s]", strCondOp));
			}
			
//			if(DataTypeUtils.isDateTimeDataType(nStdDataType)) {
//				Expression<?>  condValue = Expressions.asDateTime(DataTypeUtils.getDateTimeValue(iPSDEDQFieldCondition.getCondValue(), null));
//			}
//				
//				
//					if(DataTypeUtils.isBigDecimalDataType(nStdDataType)) {
//						Expression<?> condValue = Expressions.asNumber(DataTypeUtils.getBigDecimalValue(iPSDEDQFieldCondition.getCondValue(), null));
//					}
//					else
//						if(DataTypeUtils.isBigIntDataType(nStdDataType)) {
//							Expression<?> condValue = Expressions.asNumber(DataTypeUtils.getBigIntegerValue(iPSDEDQFieldCondition.getCondValue(), null));
//						}
//						else
//							if(DataTypeUtils.isIntDataType(nStdDataType)) {
//								Expression<?> condValue = Expressions.asNumber(DataTypeUtils.getIntegerValue(iPSDEDQFieldCondition.getCondValue(), null));
//							}
//							else
//								if(DataTypeUtils.isNumberDataType(nStdDataType)) {
//									Expression<?> condValue = Expressions.asNumber(DataTypeUtils.getDoubleValue(iPSDEDQFieldCondition.getCondValue(), null));
//								}
//								else
//									throw new Exception(String.format("未支持的标准类型[%1$s]", nStdDataType));
//			
//			
//			
//			
//			Expressions.asString(value)
//			Object condValue = DataTypeUtils.parse(iPSDEField.getStdDataType(), iPSDEDQFieldCondition.getCondValue());
//			const
			
			throw new Exception(String.format("未支持的条件操作[%1$s][%2$s]", nStdDataType, strCondOp));
		}
		
	}
	
	
//	public List<? extends QuerydslDEDataQueryBase> getUnionQuerydslDEDataQueries() {
//		return this.unionQuerydslDEDataQueryList;
//	}
//	

	
	/**
	 * 判断是否输出指定属性
	 * @param iPSDEField
	 * @param nViewColLevel
	 * @return
	 */
	protected boolean testSelectPSDEField(IPSDEField iPSDEField, int nViewColLevel) {
		if(iPSDEField.isDynaStorageDEField() || iPSDEField.isUIAssistDEField())
			return false;	
		
		if (nViewColLevel == -1)
			return iPSDEField.isQueryColumn();

		if (iPSDEField.isKeyDEField())
			return true;

		if (DEFPredefinedTypes.LOGICVALID.equalsIgnoreCase(iPSDEField.getPredefinedType()))
			return true;

		return iPSDEField.getViewLevel() >= nViewColLevel;
	}
	
	public java.util.Collection<String> getExpressionNames() {
		return psDEFieldExpressionMap.keySet();
	}
	
	public Expression<?> getExpression(String strName, boolean bTryMode) throws Exception{
		Expression<?> expression = this.psDEFieldExpressionMap.get(strName);
		if(expression != null || bTryMode) {
			return expression;
		}
		throw new Exception(String.format("无法获取指定表达式[%1$s]", strName));
	}
}
