package net.ibizsys.central.plugin.querydsl.dataentity.ds;

import net.ibizsys.model.dataentity.IPSDataEntity;

/**
 * Querydsl 会话上下文对象接口
 * @author lionlau
 *
 */
public interface IQuerydslSession {

	/**
	 * 获取别名索引
	 * @param strTag
	 * @return
	 */
	int getAliasIndex(String strTag);
	
	
	/**
	 * 获取别名
	 * @param strTag
	 * @return
	 */
	String getAlias(String strTag);
	
	
	/**
	 * 获取当前的别名索引
	 * @return
	 */
	int getCurrentAliasIndex();
	
	
	/**
	 * 获取数据库类型
	 * @return
	 */
	String getDBType();
	
	
	
	/**
	 * 获取实体对象
	 * @param iPSDataEntity
	 * @param strTag
	 * @return
	 */
	IQuerydslDataEntity getQuerydslDataEntity(IPSDataEntity iPSDataEntity, String strTag);
}
