/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.plugin.querydsl.dataentity.ds;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.sql.ForeignKey;
import com.querydsl.sql.RelationalPathBase;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.plugin.querydsl.dataentity.ds.IQuerydslDEJoin;
import net.ibizsys.central.plugin.querydsl.dataentity.ds.IQuerydslDataEntity;
import net.ibizsys.central.plugin.querydsl.dataentity.ds.IQuerydslSession;
import net.ibizsys.central.plugin.querydsl.dataentity.ds.QuerydslDEJoin;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.IPSFormulaDEField;
import net.ibizsys.model.dataentity.defield.IPSLinkDEField;
import net.ibizsys.model.dataentity.der.IPSDER1N;
import net.ibizsys.model.dataentity.der.IPSDERBase;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.DataTypes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class QuerydslDataEntityBase<T>
extends RelationalPathBase<T>
implements IQuerydslDataEntity<T> {
    private static final Log log = LogFactory.getLog(QuerydslDataEntityBase.class);
    private IQuerydslSession iQuerydslSession = null;
    private int nAliasIndex = -1;
    private String strTag = null;
    private IPSDataEntity iPSDataEntity = null;
    private Map<String, SimpleExpression<?>> psDEFieldExpressionMap = new LinkedHashMap();
    private Map<String, IPSDEField> psDEFieldMap = new HashMap<String, IPSDEField>();
    private List<Predicate> predicateList = new ArrayList<Predicate>();
    private Map<String, IQuerydslDEJoin> querydslDEJoinMap = new LinkedHashMap<String, IQuerydslDEJoin>();

    public QuerydslDataEntityBase(Class<? extends T> type, IQuerydslSession iQuerydslSession, IPSDataEntity iPSDataEntity, String strTag) {
        super(type, iQuerydslSession.getAlias(strTag), "", iPSDataEntity.getTableName());
        this.iQuerydslSession = iQuerydslSession;
        this.iPSDataEntity = iPSDataEntity;
        this.strTag = strTag;
        this.nAliasIndex = iQuerydslSession.getAliasIndex(strTag);
        List psDEFields = iPSDataEntity.getAllPSDEFields();
        if (!ObjectUtils.isEmpty((Object)psDEFields)) {
            for (IPSDEField iPSDEField : psDEFields) {
                this.psDEFieldMap.put(iPSDEField.getName().toUpperCase(), iPSDEField);
            }
        }
    }

    protected IQuerydslSession getQuerydslSession() {
        return this.iQuerydslSession;
    }

    @Override
    public IPSDataEntity getPSDataEntity() {
        return this.iPSDataEntity;
    }

    public String getTag() {
        return this.strTag;
    }

    protected SimpleExpression<?> createPSDEFieldExpression(IPSDEField iPSDEField) throws Exception {
        int nStdDataType = iPSDEField.getStdDataType();
        if (iPSDEField.isFormulaDEField()) {
            IPSFormulaDEField iPSFormulaDEField = (IPSFormulaDEField)iPSDEField;
            String strFunc = iPSFormulaDEField.getFormulaFormat();
            String strColumns = iPSFormulaDEField.getFormulaColumns();
            strFunc = strFunc.replace("%1$s", "{0}").replace("%2$s", "{1}").replace("%3$s", "{2}").replace("%4$s", "{3}").replace("%5$s", "{4}").replace("%6$s", "{5}").replace("%7$s", "{6}").replace("%8$s", "{7}");
            ArrayList expressionList = new ArrayList();
            if (StringUtils.hasLength((String)strColumns)) {
                String[] columns;
                for (String strColumn : columns = strColumns.replace(",", ";").split("[;]")) {
                    strColumn = strColumn.trim();
                    expressionList.add(this.getExpression(strColumn));
                }
            }
            if (DataTypeUtils.isStringDataType((int)nStdDataType)) {
                return Expressions.stringTemplate((String)strFunc, expressionList);
            }
            if (DataTypeUtils.isDateTimeDataType((int)nStdDataType)) {
                return Expressions.dateTimeTemplate(Timestamp.class, (String)strFunc, expressionList);
            }
            if (DataTypeUtils.isBigDecimalDataType((int)nStdDataType)) {
                return Expressions.numberTemplate(BigDecimal.class, (String)strFunc, expressionList);
            }
            if (DataTypeUtils.isBigIntDataType((int)nStdDataType)) {
                return Expressions.numberTemplate(BigInteger.class, (String)strFunc, expressionList);
            }
            if (DataTypeUtils.isIntDataType((int)nStdDataType)) {
                return Expressions.numberTemplate(Integer.class, (String)strFunc, expressionList);
            }
            if (DataTypeUtils.isNumberDataType((int)nStdDataType)) {
                return Expressions.numberTemplate(Double.class, (String)strFunc, expressionList);
            }
        } else {
            if (DataTypeUtils.isStringDataType((int)nStdDataType)) {
                return this.createString(iPSDEField.getName());
            }
            if (DataTypeUtils.isDateTimeDataType((int)nStdDataType)) {
                return this.createDateTime(iPSDEField.getName(), Timestamp.class);
            }
            if (DataTypeUtils.isBigDecimalDataType((int)nStdDataType)) {
                return this.createNumber(iPSDEField.getName(), BigDecimal.class);
            }
            if (DataTypeUtils.isBigIntDataType((int)nStdDataType)) {
                return this.createNumber(iPSDEField.getName(), BigInteger.class);
            }
            if (DataTypeUtils.isIntDataType((int)nStdDataType)) {
                return this.createNumber(iPSDEField.getName(), Integer.class);
            }
            if (DataTypeUtils.isNumberDataType((int)nStdDataType)) {
                return this.createNumber(iPSDEField.getName(), Double.class);
            }
            if (DataTypeUtils.isBinaryType((int)nStdDataType)) {
                return this.createArray(iPSDEField.getName(), Byte.class);
            }
        }
        throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u5c5e\u6027[%1$s][%2$s]", iPSDEField.getName(), DataTypes.toString((int)nStdDataType)));
    }

    @Override
    public IPSDEField getPSDEField(String strPSDEFieldName, boolean bTryMode) throws Exception {
        IPSDEField iPSDEField = this.psDEFieldMap.get(strPSDEFieldName.toUpperCase());
        if (iPSDEField != null || bTryMode) {
            return iPSDEField;
        }
        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5c5e\u6027[%1$s]", strPSDEFieldName));
    }

    @Override
    public SimpleExpression<?> getExpression(String strPSDEFieldName) throws Exception {
        return this.getExpression(this.getPSDEField(strPSDEFieldName, false));
    }

    @Override
    public SimpleExpression<?> getExpression(IPSDEField iPSDEField) throws Exception {
        SimpleExpression expression = this.psDEFieldExpressionMap.get(iPSDEField.getName());
        if (expression == null) {
            if (iPSDEField.isPhisicalDEField()) {
                expression = this.createPSDEFieldExpression(iPSDEField);
                this.psDEFieldExpressionMap.put(iPSDEField.getName(), expression);
            } else if (iPSDEField.isLinkDEField()) {
                IPSLinkDEField iPSLinkDEField = (IPSLinkDEField)iPSDEField;
                IPSDERBase iPSDERBase = iPSLinkDEField.getPSDERMust();
                String strJoinType = null;
                switch (iPSDERBase.getDERType()) {
                    case "DER1N": {
                        strJoinType = "N1";
                        break;
                    }
                    case "DER11": {
                        strJoinType = "11";
                        break;
                    }
                    case "DERINDEX": 
                    case "DERINHERIT": {
                        strJoinType = "INDEX";
                        break;
                    }
                    default: {
                        throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u5173\u7cfb\u7c7b\u578b[%1$s]", iPSDERBase.getDERType()));
                    }
                }
                IQuerydslDataEntity refQuerydslDataEntity = this.getJoinQuerydslDataEntity(strJoinType, iPSDERBase);
                expression = (SimpleExpression)refQuerydslDataEntity.getExpression(iPSLinkDEField.getRelatedPSDEFieldMust());
                this.psDEFieldExpressionMap.put(iPSDEField.getName(), expression);
            } else if (iPSDEField.isFormulaDEField()) {
                expression = this.createPSDEFieldExpression(iPSDEField);
                this.psDEFieldExpressionMap.put(iPSDEField.getName(), expression);
            } else {
                throw new Exception(String.format("\u672a\u652f\u6301\u7684\u5c5e\u6027[%1$s:%2$s]", iPSDEField.getName(), iPSDEField.getDataType()));
            }
        }
        return expression;
    }

    @Override
    public IQuerydslDataEntity getJoinQuerydslDataEntity(String strJoinType, IPSDERBase iPSDERBase) throws Exception {
        String strJoinTag = String.format("%1$s:%2$s", strJoinType, iPSDERBase.getId());
        IQuerydslDEJoin iQuerydslDEJoin = this.querydslDEJoinMap.get(strJoinTag);
        if (iQuerydslDEJoin == null) {
            IPSDataEntity realPSDataEntity = null;
            switch (strJoinType) {
                case "N1": {
                    realPSDataEntity = iPSDERBase.getMajorPSDataEntityMust();
                    break;
                }
                case "1N": {
                    realPSDataEntity = iPSDERBase.getMinorPSDataEntityMust();
                    break;
                }
                case "1NNOT": {
                    realPSDataEntity = iPSDERBase.getMinorPSDataEntityMust();
                    break;
                }
                default: {
                    throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u8fde\u63a5\u7c7b\u578b[%1$s]", strJoinType));
                }
            }
            String strFullTag = String.format("%1$s|%2$s", this.getTag(), strJoinTag);
            IQuerydslDataEntity iQuerydslDataEntity = this.getQuerydslSession().getQuerydslDataEntity(realPSDataEntity, strFullTag);
            switch (strJoinType) {
                case "N1": {
                    IPSDER1N iPSDER1N = (IPSDER1N)iPSDERBase;
                    ForeignKey foreignKey = this.createForeignKey((Path)this.getExpression((IPSDEField)iPSDER1N.getPSPickupDEFieldMust()), realPSDataEntity.getKeyPSDEFieldMust().getName());
                    iQuerydslDEJoin = new QuerydslDEJoin(this, "LEFTJOIN", iPSDERBase, foreignKey, iQuerydslDataEntity);
                    this.querydslDEJoinMap.put(strJoinTag, iQuerydslDEJoin);
                    break;
                }
                case "1N": {
                    IPSDER1N iPSDER1N = (IPSDER1N)iPSDERBase;
                    BooleanBuilder booleanBuilder = new BooleanBuilder();
                    SimpleExpression<?> expression = this.getExpression(this.getPSDataEntity().getKeyPSDEFieldMust());
                    iQuerydslDataEntity.getPredicates().add((Predicate)expression.eq(iQuerydslDataEntity.getExpression((IPSDEField)iPSDER1N.getPSPickupDEFieldMust())));
                    iQuerydslDEJoin = new QuerydslDEJoin(this, "EXISTS", iPSDERBase, null, iQuerydslDataEntity);
                    this.querydslDEJoinMap.put(strJoinTag, iQuerydslDEJoin);
                    break;
                }
                case "1NNOT": {
                    IPSDER1N iPSDER1N = (IPSDER1N)iPSDERBase;
                    BooleanBuilder booleanBuilder = new BooleanBuilder();
                    SimpleExpression<?> expression = this.getExpression(this.getPSDataEntity().getKeyPSDEFieldMust());
                    iQuerydslDataEntity.getPredicates().add((Predicate)expression.eq(iQuerydslDataEntity.getExpression((IPSDEField)iPSDER1N.getPSPickupDEFieldMust())));
                    iQuerydslDEJoin = new QuerydslDEJoin(this, "NOTEXISTS", iPSDERBase, null, iQuerydslDataEntity);
                    this.querydslDEJoinMap.put(strJoinTag, iQuerydslDEJoin);
                    break;
                }
                default: {
                    throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u8fde\u63a5\u7c7b\u578b[%1$s]", strJoinType));
                }
            }
        }
        return iQuerydslDEJoin.getJoinQuerydslDataEntity();
    }

    @Override
    public Collection<IQuerydslDEJoin> getQuerydslDEJoins() {
        return this.querydslDEJoinMap.values();
    }

    @Override
    public Collection<Predicate> getPredicates() {
        return this.predicateList;
    }
}

