package net.ibizsys.central.plugin.querydsl.dataentity.ds;

import java.util.HashMap;
import java.util.Map;

import net.ibizsys.model.dataentity.IPSDataEntity;

public class QuerydslSession implements IQuerydslSession {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(QuerydslSession.class);
	
	private Map<String, IQuerydslDataEntity> querydslDataEntityMap = new HashMap<String, IQuerydslDataEntity>();
	private Map<String, Integer> aliasIndexMap = new HashMap<String, Integer>();
	
	private int nAliasIndex = 1;
	private String strDBType = null;
	

	@Override
	public int getAliasIndex(String strTag) {
		Integer nRet = this.aliasIndexMap.get(strTag);
		if(nRet == null) {
			nRet = nAliasIndex;
			nAliasIndex += 10;
			this.aliasIndexMap.put(strTag, nRet);
		}
		return nRet;
	}

	@Override
	public int getCurrentAliasIndex() {
		return this.nAliasIndex;
	}

	@Override
	public String getAlias(String strTag) {
		return String.format("t%1$s", this.getAliasIndex(strTag));
	}

	@Override
	public String getDBType() {
		return this.strDBType;
	}
	
	public void setDBType(String strDBType) {
		this.strDBType = strDBType;
	}

	@Override
	public IQuerydslDataEntity getQuerydslDataEntity(IPSDataEntity iPSDataEntity, String strTag) {

		IQuerydslDataEntity iQuerydslDataEntity = this.querydslDataEntityMap.get(strTag);
		if(iQuerydslDataEntity == null) {
			iQuerydslDataEntity = this.createQuerydslDataEntity(iPSDataEntity, strTag);
			this.querydslDataEntityMap.put(strTag, iQuerydslDataEntity);
		}
		return iQuerydslDataEntity;
	}
	
	protected IQuerydslDataEntity createQuerydslDataEntity(IPSDataEntity iPSDataEntity, String strTag) {
		return new QuerydslDataEntity(this, iPSDataEntity, strTag);
	}
	
	

}
